#include "TCanvas.h"
#include "TStyle.h"
#include "TH1.h"


void w_prof_norm_AA(
 char const *p_qq, //!< name of the ROOT input file
 char const *p_NN
            ) {

TCanvas *c1 = new TCanvas("c1","qq and NN wounding profiles",600,400);
gStyle->SetOptStat(kFALSE);
gStyle->SetHistLineWidth(2);		
			
TString empty("");

// Default file name
//TString inpfile_qq("glissando.root");
char const *inpfile_qq = "glissando.root";
 if (p_qq!=empty) inpfile_qq = p_qq;
 cout << "reads from: " << inpfile_qq << endl;;  

//TString inpfile_NN("glissando.root");
char const *inpfile_NN = "glissando.root";
if (p_NN!=empty) inpfile_NN = p_NN;
cout << "reads from: " << inpfile_NN << endl;;  
 
TFile *f_qq = new TFile(inpfile_qq);
TFile *f_NN = new TFile(inpfile_NN);

TTree *itree_qq = (TTree*)f_qq->Get("events");
TTree *param_qq = (TTree*)f_qq->Get("param");
TTree *phys_qq  = (TTree*)f_qq->Get("phys");

TTree *itree_NN = (TTree*)f_NN->Get("events");
TTree *param_NN = (TTree*)f_NN->Get("param");
TTree *phys_NN  = (TTree*)f_NN->Get("phys");

Float_t b,BMIN,BMAX,SNN,sitot,ECM_qq,ECM_NN;
Int_t NUMA,NUMB;
Int_t max=100;
Double_t PI=3.14159265;

itree_qq->SetBranchAddress("b",&b);
param_qq->SetBranchAddress("BMIN",&BMIN);param_qq->GetEntry(0);
param_qq->SetBranchAddress("BMAX",&BMAX);param_qq->GetEntry(0);
param_qq->SetBranchAddress("ECM",&ECM_qq);param_qq->GetEntry(0);
param_qq->SetBranchAddress("NUMA",&NUMA);param_qq->GetEntry(0);
param_qq->SetBranchAddress("NUMB",&NUMB);param_qq->GetEntry(0);
phys_qq->SetBranchAddress("sitot",&sitot);phys_qq->GetEntry(0);
param_NN->SetBranchAddress("ECM",&ECM_NN);param_NN->GetEntry(0);

cout << "qq, center-of-mass-energy, sqrt(s_NN): " << ECM_qq << " GeV" << endl;
cout << "NN, center-of-mass-energy, sqrt(s_NN): " << ECM_NN << " GeV" << endl;

Float_t st=sitot/10; // in fm^2
Int_t nentries = (Int_t)itree_qq->GetEntries();

TH1D *hist_b_qq        = new TH1D("hist_b_qq","raw wounding profile",max,BMIN,BMAX);
TH1D *hist_b_1_qq      = new TH1D("hist_b_1_qq","Wounding profile normalized to the model NN cross section",max,BMIN,BMAX);
TH1D *hist_b_norm_qq   = new TH1D("hist_b_norm_qq","scaled wounding profile",max,BMIN,BMAX/sqrt(st));
TH1D *hist_b_norm_1_qq = new TH1D("hist_b_norm_1_qq","radial scaled wounding profile normalized to 1",max,BMIN,BMAX/sqrt(st));



for (Int_t i=1; i<=nentries; i++) {
    itree_qq->GetEntry(i);
    hist_b_qq->Fill(b,1/(2*PI*b));
}
TAxis *xaxis;
Float_t szer;
Float_t ile;

xaxis = hist_b_qq->GetXaxis();
szer  = xaxis->GetBinWidth(1);
ile   = hist_b_qq->GetEntries(); 

for (Int_t i=1; i<=max; i++) {
    Float_t vp =(hist_b_qq->GetBinContent(i));
    hist_b_1_qq->SetBinContent(i,st*vp/ile/szer);
}

Float_t alpha=0.0;
Float_t calka=0.0;
for (Int_t i=1;i<=max;i++) {
    Float_t vp =(hist_b_1_qq->GetBinContent(i));
    Float_t cent = (hist_b_1_qq->GetBinCenter(i));

    alpha+=2*PI*cent*vp*szer;
}

cout << "qq, test of normalization (should return the cross section: " << 10*alpha << "mb" << endl;


for (Int_t i=1; i<=max; i++) {
    Float_t vp =(hist_b_1_qq->GetBinContent(i));
    hist_b_norm_qq->SetBinContent(i,vp);
}

xaxis = hist_b_norm_qq->GetXaxis();
szer  = xaxis->GetBinWidth(1);
Int_t ile_norm = hist_b_norm_qq->GetEntries(); 

for (Int_t i=1;i<=max;i++) {
    Float_t vp =(hist_b_norm_qq->GetBinContent(i));
    Float_t cent = (hist_b_norm_qq->GetBinCenter(i));

    calka+=2*PI*cent*vp*szer;
}

cout << "qq, normalized integral (should be 1): " <<calka<<endl;

for (Int_t i=1; i<=max; i++) {
    Float_t vp =(hist_b_norm_qq->GetBinContent(i));
    Float_t cent = (hist_b_norm_qq->GetBinCenter(i));

    hist_b_norm_1_qq->SetBinContent(i,2*PI*cent*vp);
}
hist_b_1_qq->SetLineColor(kRed);
hist_b_1_qq->SetLineStyle(2);

Float_t title_offset=0.8;
Float_t label_offset=0.01;
Float_t title_size=0.05;
Float_t label_size=0.05;

hist_b_1_qq->SetTitle("Wounding profile normalized to the model NN cross section");
hist_b_1_qq->SetStats(kFALSE);
hist_b_1_qq->GetXaxis()->SetTitleOffset(title_offset);
hist_b_1_qq->GetXaxis()->SetLabelOffset(label_offset);
hist_b_1_qq->GetXaxis()->SetTitleSize(title_size);
hist_b_1_qq->GetXaxis()->SetLabelSize(label_size);
hist_b_1_qq->GetYaxis()->SetTitleOffset(title_offset);
hist_b_1_qq->GetYaxis()->SetLabelOffset(label_offset);
hist_b_1_qq->GetYaxis()->SetTitleSize(title_size);
hist_b_1_qq->GetYaxis()->SetLabelSize(label_size);
hist_b_1_qq->GetXaxis()->SetTitle("b [fm]   ");
hist_b_1_qq->GetYaxis()->SetTitle("P_{in}(b) ");
hist_b_1_qq->Draw();
c1->Update();

itree_NN->SetBranchAddress("b",&b);
param_NN->SetBranchAddress("BMIN",&BMIN);param_NN->GetEntry(0);
param_NN->SetBranchAddress("BMAX",&BMAX);param_NN->GetEntry(0);
phys_NN->SetBranchAddress("sitot",&sitot);phys_NN->GetEntry(0);

st=sitot/10; // in fm^2
nentries = (Int_t)itree_NN->GetEntries();


TH1D *hist_b_NN        = new TH1D("hist_b_NN","raw wounding profile",max,BMIN,BMAX);
TH1D *hist_b_1_NN      = new TH1D("hist_b_1_NN","wounding profile normalized to the model NN cross section",max,BMIN,BMAX);
TH1D *hist_b_norm_NN   = new TH1D("hist_b_norm_NN","scaled wounding profile",max,BMIN,BMAX/sqrt(st));
TH1D *hist_b_norm_1_NN = new TH1D("hist_b_norm_1_NN","radial scaled wounding profile normalized to 1",max,BMIN,BMAX/sqrt(st));

for (Int_t i=1; i<=nentries; i++) {
    itree_NN->GetEntry(i);
    hist_b_NN->Fill(b,1/(2*PI*b));
}

xaxis = hist_b_NN->GetXaxis();
szer  = xaxis->GetBinWidth(1);
ile   = hist_b_NN->GetEntries(); 

for (Int_t i=1; i<=max; i++) {
    Float_t vp =(hist_b_NN->GetBinContent(i));
    hist_b_1_NN->SetBinContent(i,st*vp/ile/szer);
}

alpha=0.0;
calka=0.0;
for (Int_t i=1;i<=max;i++) {
    Float_t vp =(hist_b_1_NN->GetBinContent(i));
    Float_t cent = (hist_b_1_NN->GetBinCenter(i));

    alpha+=2*PI*cent*vp*szer;
}

cout << "NN, test of normalization (should return the cross section: " << 10*alpha << "mb" << endl;


for (Int_t i=1; i<=max; i++) {
    Float_t vp =(hist_b_1_NN->GetBinContent(i));
    hist_b_norm_NN->SetBinContent(i,vp);
}

xaxis    = hist_b_norm_NN->GetXaxis();
szer     = (xaxis->GetBinWidth(1));
ile_norm = (hist_b_norm_NN->GetEntries()); 

for (Int_t i=1;i<=max;i++) {
    Float_t vp =(hist_b_norm_NN->GetBinContent(i));
    Float_t cent = (hist_b_norm_NN->GetBinCenter(i));

    calka+=2*PI*cent*vp*szer;
}

cout << "NN, normalized integral (should be 1): " <<calka<<endl;

for (Int_t i=1; i<=max; i++) {
    Float_t vp =(hist_b_norm_NN->GetBinContent(i));
    Float_t cent = (hist_b_norm_NN->GetBinCenter(i));

    hist_b_norm_1_NN->SetBinContent(i,2*PI*cent*vp);
}

hist_b_1_NN->SetLineColor(kBlue);
hist_b_1_NN->SetLineStyle(1);
hist_b_1_NN->Draw("same");
cout << endl;

Double_t xl1=.65, yl1=0.6, xl2=xl1+.2, yl2=yl1+.12;
TLegend *leg = new TLegend(xl1,yl1,xl2,yl2);
leg->SetFillColor(0);
leg->SetBorderSize(0);
leg->AddEntry(hist_b_1_qq, "quarks", "l");
leg->AddEntry(hist_b_1_NN, "nucleons", "l");
leg->Draw("SAME");

char tEVENTS[60], tEVENTS2[60];

sprintf(tEVENTS,"%d+%d @ %.0f GeV",NUMA,NUMB,ECM_qq);
sprintf(tEVENTS2,"GLISSANDO 3");

Float_t x1=0.6, x2=0.6;
Float_t off1=0.77, off2=0.85;

TLatex *t1 = new TLatex();
t1->SetNDC();
t1->SetTextAlign(13);
t1->SetTextFont(32);
t1->SetTextColor(kBlack);
t1->SetTextSizePixels(18);
t1->SetTextAlign(12);
t1->DrawLatex(x1,off1,tEVENTS);  
t1->DrawLatex(x2,off2,tEVENTS2);

c1->Modified();
c1->cd();
c1->SetSelected(c1);

c1->SaveAs("w_prof_norm_AA.pdf");


TFile *hfile = new TFile("w_prof_norm_AA.root","RECREATE");
hfile->cd();
hist_b_qq->Write();
hist_b_1_qq->Write();
hist_b_norm_qq->Write();
hist_b_norm_1_qq->Write();

hist_b_NN->Write();
hist_b_1_NN->Write();
hist_b_norm_NN->Write();
hist_b_norm_1_NN->Write();

hfile->Close(); 

}
