/** \file rad_dis.C
 * Script yielding the radial distribution of nucleons or partons
 * (part of GLISSANDO 3)
 * 
 */

#include "label.C"

//! radial distribution of nucleons or partons
/*! for _profile_=0 - nucleons, for _profile_=1 - partons */
void rad_dis(
     char const *p //!< name of the ROOT input file 
         ) {

gROOT->Reset();

TString empty("");

// Default file name
//TString inpfile("glissando.root");
char const *inpfile = "glissando.root";

 if (p!=empty) inpfile = p;
 cout << "reads from: " << inpfile << endl;;  

TFile *f = new TFile(inpfile);
TTree *param = (TTree*)f->Get("param");

TH1D *hr = ((TH1D*)f->Get("radA")); 

Float_t ECM;
Int_t PARTONS,NUMA,NUMB;

param->SetBranchAddress("PARTONS",&PARTONS);param->GetEntry(0);
param->SetBranchAddress("ECM",&ECM);param->GetEntry(0);
param->SetBranchAddress("NUMA",&NUMA);param->GetEntry(0);
param->SetBranchAddress("NUMB",&NUMB);param->GetEntry(0);

char tEVENTS[60];
sprintf(tEVENTS,"GLISSANDO 3    %.0f GeV",ECM);

Float_t x=0.55;
Float_t off1=0.85;

TLatex *t1 = new TLatex();
t1->SetNDC();
t1->SetTextAlign(13);
t1->SetTextFont(32);
t1->SetTextColor(kBlack);
t1->SetTextSizePixels(75);
t1->SetTextAlign(12);

Float_t title_offset=0.8;
Float_t label_offset=0.01;
Float_t title_size=0.05;
Float_t label_size=0.05;

TCanvas *c1= new TCanvas("c1", "Radial distribution of quarks in nucleon",0,0,1000,600);
c1->Range(0,0,25,18);
c1->SetFillColor(0);

gPad->SetFillStyle(4000);
gPad->SetFillColor(0);

hr->SetTitle("Radial distribution of quarks in nucleon");
hr->SetStats(kFALSE);
hr->GetXaxis()->SetTitleOffset(title_offset);
hr->GetXaxis()->SetLabelOffset(label_offset);
hr->GetXaxis()->SetTitleSize(title_size);
hr->GetXaxis()->SetLabelSize(label_size);
hr->GetYaxis()->SetTitleOffset(title_offset);
hr->GetYaxis()->SetLabelOffset(label_offset);
hr->GetYaxis()->SetTitleSize(title_size);
hr->GetYaxis()->SetLabelSize(label_size);

hr->SetXTitle("r [fm] ");
hr->SetYTitle("4 #pi r^{2} #rho(r)");

Float_t sc=1./(hr->Integral())/(hr->GetBinWidth(1));
hr->Scale(sc);
hr->SetLineColor(kBlue);
hr->Draw("HIST");  
t1->DrawLatex(x,off1,tEVENTS);

c1->SaveAs("rad_dis.pdf");

}
