/** \file wounding_profile.C
 * Script generating the wounding (inelasticity) profile
 * (part of GLISSANDO 3)
 */

#include "label.C"

//! generates the plots of the wounding profile  
/* Generates the plots of the wounding collision profile as functions of the square of separation of the sources */

void inel_prof(
            char const *p, 
            char const *q,
            char const *q10 //!< names of the ROOT input files
                ){

gStyle->SetHistLineWidth(2);

TString empty("");

// ------------------------------------------------------------------------
// Default file name
char const *inpfile = "glissando.root";

 if (p!=empty) inpfile = p;
 cout << "reads from: " << inpfile << endl;;  

TFile *f     = new TFile(inpfile);
TTree *phys  = (TTree*)f->Get("phys");
TTree *itree = (TTree*)f->Get("events");

Float_t sitot;
Float_t b;

phys->SetBranchAddress("sitot",&sitot);phys->GetEntry(0);
cout << "inelastic cross section: " << sitot << " mb" << endl; 
itree->SetBranchAddress("b",&b);

TH1D *h = new TH1D("h","Inelasticity profile",100,0.,3);
Int_t nentries = (Int_t)itree->GetEntries();

for (Int_t i=1; i<=nentries; i++) {
    itree->GetEntry(i);
    h->Fill(b,1);
}

Int_t ile = h->GetEntries();
Float_t norm=(h->Integral())/ile;

for (Int_t i=1;i<=100;i++) {
    Int_t v = (h->GetBinContent(i));
    Float_t cent =1+0*(h->GetBinCenter(i));
    h->SetBinContent(i,v/cent/(3./100.)/ile*sitot/10./(2.*3.14159265));
}

// ----------------------------------------------------------------------
// Default file name
TString inpfile2("glissando.root");
 if (q!=empty) inpfile2 = q;
 cout << "reads from: " << inpfile2 << endl;;

TFile *f2 = new TFile(inpfile2);
TTree *phys2 = (TTree*)f2->Get("phys");

phys2->SetBranchAddress("sitot",&sitot);
phys2->GetEntry(0);
cout << "inelastic cross section 2: " << sitot << " mb" << endl;

TTree *itree2 = (TTree*)f2->Get("events");
itree2->SetBranchAddress("b",&b);

TH1D *h2 = new TH1D("h2","inelasticity profile",100,0.,3);
Int_t nentries2 = (Int_t)itree2->GetEntries();

for (Int_t i=1; i<=nentries2; i++) {
    itree2->GetEntry(i);
    h2->Fill(b,1);
}

Int_t ile2 = h2->GetEntries();
Float_t norm2=(h2->Integral())/ile2;

for (Int_t i=1;i<=100;i++) {
    Int_t v2 = (h2->GetBinContent(i));
    Float_t cent2 = 1+0*(h2->GetBinCenter(i));
    h2->SetBinContent(i,v2/cent2/(3./100.)/ile2*sitot/10./(2.*3.14159265));
}

// ----------------------------------------------------------------------
// Default file name
TString inpfile3("glissando.root");
 if (q10!=empty) inpfile3 = q10;
 cout << "reads from: " << inpfile3 << endl;;

TFile *f3 = new TFile(inpfile3);
TTree *phys3 = (TTree*)f3->Get("phys");

phys3->SetBranchAddress("sitot",&sitot);
phys3->GetEntry(0);
cout << "inelastic cross section 3: " << sitot << " mb" << endl;

TTree *itree3 = (TTree*)f3->Get("events");
itree3->SetBranchAddress("b",&b);

TH1D *h3 = new TH1D("h3","inelasticity profile",100,0.,3);
Int_t nentries3 = (Int_t)itree3->GetEntries();

for (Int_t i=1; i<=nentries3; i++) {
    itree3->GetEntry(i);
    h3->Fill(b,1);
}

Int_t ile3 = h3->GetEntries();
Float_t norm3=(h3->Integral())/ile3;

for (Int_t i=1;i<=100;i++) {
    Int_t v3 = (h3->GetBinContent(i));
    Float_t cent3 = 1+0*(h3->GetBinCenter(i));
    h3->SetBinContent(i,v3/cent3/(3./100.)/ile3*sitot/10./(2.*3.14159265));
}


// -----------------------------------------------------------------------

TCanvas *c1= new TCanvas("c1", " inelasticity profile",0,0,1000,600);
   c1->Range(0,0,25,18);
   c1->SetFillColor(0);
   
gPad->SetFillStyle(4000);
gPad->SetFillColor(0);

Float_t title_offset=0.8;
Float_t label_offset=0.01;
Float_t title_size=0.05;
Float_t label_size=0.05;

label(inpfile);

h->SetStats(kFALSE);
h->GetXaxis()->SetTitleOffset(title_offset);
h->GetXaxis()->SetLabelOffset(label_offset);
h->GetXaxis()->SetTitleSize(title_size);
h->GetXaxis()->SetLabelSize(label_size);
h->GetYaxis()->SetTitleOffset(title_offset);
h->GetYaxis()->SetLabelOffset(label_offset);
h->GetYaxis()->SetTitleSize(title_size);
h->GetYaxis()->SetLabelSize(label_size);
h->SetXTitle("b [fm]   ");
h->SetYTitle("b p_{in}(b)");
h->SetLineColor(kBlue);
h->SetLineStyle(1);
h->Draw();

h2->SetLineColor(kRed);
h2->SetLineStyle(2);
h2->Draw("SAME");

h3->SetLineColor(kBlack);
h3->SetLineStyle(3);
h3->Draw("SAME");

Int_t NUMA, NUMB;
Int_t PARTONS;
Float_t ECM_qq,ECM_NN,ALPHA;

TTree *param_NN = (TTree*)f->Get("param");
param_NN->SetBranchAddress("PARTONS",&PARTONS);param_NN->GetEntry(0);
param_NN->SetBranchAddress("NUMA",&NUMA);param_NN->GetEntry(0);
param_NN->SetBranchAddress("NUMB",&NUMB);param_NN->GetEntry(0);
param_NN->SetBranchAddress("ALPHA",&ALPHA);param_NN->GetEntry(0);
param_NN->SetBranchAddress("ECM",&ECM_NN);param_NN->GetEntry(0);
cout << "NN, center-of-mass-energy, sqrt(s_NN): " << ECM_NN << " GeV" << endl;

char tEVENTS[60];
sprintf(tEVENTS,"GLISSANDO 3    %d+%d @ %.0f GeV",NUMA,NUMB,ECM_NN);

Float_t x=0.45;
Float_t off1=0.85, off2=0.8, off3=0.75;

TLatex *t1 = new TLatex();
t1->SetNDC();
t1->SetTextAlign(13);
t1->SetTextFont(32);
t1->SetTextColor(kBlack);
t1->SetTextSizePixels(18);
t1->SetTextAlign(12);
t1->DrawLatex(x,off1,tEVENTS);


TLegend *leg = new TLegend(0.65,0.5,0.85,0.8);
leg->SetBorderSize(0);
leg->SetFillColor(0);
leg->AddEntry(h, " nucleons ", "l");
leg->AddEntry(h2, " 3 partons ", "l");
leg->AddEntry(h3, "10 partons ", "l");
leg->Draw("SAME");

c1->Modified();
c1->cd();
c1->SetSelected(c1);

c1->SaveAs("inel_prof.pdf");

}
