/** \file fourier.C
 * Script generating the epsilon_n vs. Q_w plot
 * (part of GLISSANDO 3)
 */

#include "label.C"

//! generates the plot of epsilon_n vs. Qw, n=2,3
/* Useful for flow analysis in NN collisions*/
void fourier_Q(
            char const *p, //!< name of the ROOT input file
            Int_t up //!< x-range of the plot 
                ){

gROOT->Reset();
gStyle->SetPalette(1);
gStyle->SetHistLineWidth(2);

TString empty("");

// Default file name
//TString inpfile("glissando.root");
char const *inpfile = "glissando.root";

 if (p!=empty) inpfile = p;
 cout << "reads from: " << inpfile << endl;;  

TFile *f = new TFile(inpfile);
TTree *itree = (TTree*)f->Get("events");

label(inpfile);

TCanvas *c0 = new TCanvas("c0", "c2",49,120,648,439);

TH2D *h2 = new TH2D("h2","ep_2 vs Nw",up,0.5,up+0.5,100,-1,1);
itree -> Draw("eps:nwAB >> h2");

TH2D *h3 = new TH2D("h3","ep_3 vs Nw",up,0.5,up+0.5,100,-1,1);
itree -> Draw("ep3s:nwAB >> h3");

TCanvas *c2 = new TCanvas("c2","Eccentricities",0,0,1000,600);
c2->cd(1);
c2->Range(0,0,25,18);
c2->SetFillColor(0);

gPad->SetFillStyle(4000);
gPad->SetFillColor(0);


Float_t title_offset=0.8;
Float_t label_offset=0.01;
Float_t title_size=0.05;
Float_t label_size=0.05;

label(inpfile);

TProfile *p2 = h2->ProfileX("p2"); 
p2->SetLineColor(kRed);
p2->SetStats(kFALSE);
p2->GetXaxis()->SetTitleOffset(title_offset);
p2->GetXaxis()->SetLabelOffset(label_offset);
p2->GetXaxis()->SetTitleSize(title_size);
p2->GetXaxis()->SetLabelSize(label_size);
p2->GetYaxis()->SetTitleOffset(title_offset);
p2->GetYaxis()->SetLabelOffset(label_offset);
p2->GetYaxis()->SetTitleSize(title_size);
p2->GetYaxis()->SetLabelSize(label_size);

p2->SetTitle("Eccentricities: n=2,3");
p2->SetXTitle("Q_{W}      ");
p2->SetYTitle("#epsilon_{n}  ");
p2->Draw("hist");

TProfile *p3 = h3->ProfileX("p3"); 
p3->SetLineColor(kBlue);
p3->SetLineStyle(2);
p3->SetStats(kFALSE);
p3->Draw("histSAME");


TLegend *leg = new TLegend(0.69,0.60,.85,0.75);
leg->SetFillColor(0);
leg->SetBorderSize(0);
leg->AddEntry(p2, "  n=2", "l");
leg->AddEntry(p3, "  n=3", "l");
leg->Draw("SAME");

Int_t NUMA, NUMB;
Int_t PARTONS;
Float_t ECM_qq,ECM_NN,ALPHA;

TTree *param_NN = (TTree*)f->Get("param");
param_NN->SetBranchAddress("PARTONS",&PARTONS);param_NN->GetEntry(0);
param_NN->SetBranchAddress("NUMA",&NUMA);param_NN->GetEntry(0);
param_NN->SetBranchAddress("NUMB",&NUMB);param_NN->GetEntry(0);
param_NN->SetBranchAddress("ALPHA",&ALPHA);param_NN->GetEntry(0);
param_NN->SetBranchAddress("ECM",&ECM_NN);param_NN->GetEntry(0);

cout << "NN, center-of-mass-energy, sqrt(s_NN): " << ECM_NN << " GeV" << endl;

char tEVENTS[60];
sprintf(tEVENTS,"GLISSANDO 3   %d+%d @ %.0f GeV",NUMA,NUMB,ECM_NN);

char tOPIS[60];
if (ALPHA!=0.0)
    sprintf(tOPIS,"mixed model with ALPHA=%.3f",ALPHA);
else if (PARTONS==0) 
    sprintf(tOPIS,"wounded nucleon model");
  else 
      sprintf(tOPIS,"wounded quark model");

Float_t x1=0.50, x2=0.62;
Float_t off1=0.86, off2=0.8;

TLatex *t1 = new TLatex();
t1->SetNDC();
t1->SetTextAlign(13);
t1->SetTextFont(32);
t1->SetTextColor(kBlack);
t1->SetTextSizePixels(18);
t1->SetTextAlign(12);
t1->DrawLatex(x1,off1,tEVENTS);
t1->DrawLatex(x2,off2,tOPIS);
c2->Modified();
c2->cd();
c2->SetSelected(c0);

c2->SaveAs("eps_23.pdf");
}
