void eps_dist(
            char const *p //!< name of the ROOT input file
                ){
gROOT->Reset();
gStyle->SetPalette(1);

//TString empty("");
 char const *empty = "";

// Default file name
//TString inpfile("glissando.root");

 char const *inpfile = "glissando.root";
 if (p!=empty) inpfile = p;
 cout << "reads from: " << inpfile << endl;

 
TFile *f = new TFile(inpfile);
TTree *itree = (TTree*)f->Get("events");
TTree *param = (TTree*)f->Get("param"); 

Float_t eps, ep3s; 

Int_t st=40;

itree->SetBranchAddress("eps",&eps);
itree->SetBranchAddress("ep3s",&ep3s);


TH1D *hist_eps = new TH1D("hist_eps","eccentricity distribution",st,0,1);
TH1D *hist_ep3s = new TH1D("hist_ep3s","",st,0,1);

Int_t nentries = (Int_t)itree->GetEntries();

for (Int_t i=1; i<=nentries; i++) {
itree->GetEntry(i);
hist_eps->Fill(eps,1);
hist_ep3s->Fill(ep3s,1);
}

TCanvas *c1 = new TCanvas("c1","eccentricity distribution",500,350);
   gStyle->SetOptStat(0);


hist_ep3s->GetXaxis()->SetLabelOffset(0.01);
hist_ep3s->GetXaxis()->SetTitleSize(0.05);
hist_ep3s->GetXaxis()->SetTitle("eccentricity");
hist_ep3s->GetYaxis()->SetLabelOffset(0.008);
hist_ep3s->GetYaxis()->SetTitleSize(0.055);
hist_ep3s->GetYaxis()->SetTitleOffset(0.7);
hist_ep3s->GetYaxis()->SetTitle("P(#epsilon_{n})");

hist_eps->Scale(1./(hist_eps->Integral()/st));
hist_ep3s->Scale(1./(hist_ep3s->Integral()/st));


hist_eps->SetLineColor(kRed);
hist_ep3s->SetLineColor(kBlue);

hist_ep3s->SetLineStyle(9);
hist_eps->SetLineWidth(3);
hist_ep3s->SetLineWidth(3);


hist_ep3s->Draw("HIST");
hist_eps->Draw("HISTSAME");

Float_t title_offset=.8;
//label(inpfile);

//inv->Draw();


Int_t NUMA, NUMB;
Int_t PARTONS;
Float_t ECM_qq,ECM_NN,ALPHA;

TTree *param_NN = (TTree*)f->Get("param");

param_NN->SetBranchAddress("PARTONS",&PARTONS);param_NN->GetEntry(0);
param_NN->SetBranchAddress("NUMA",&NUMA);param_NN->GetEntry(0);
param_NN->SetBranchAddress("NUMB",&NUMB);param_NN->GetEntry(0);
param_NN->SetBranchAddress("ALPHA",&ALPHA);param_NN->GetEntry(0);

param_NN->SetBranchAddress("ECM",&ECM_NN);param_NN->GetEntry(0);

cout << "NN, center-of-mass-energy, sqrt(s_NN): " << ECM_NN << " GeV" << endl;


Char_t tEVENTS[60];
sprintf(tEVENTS,"GLISSANDO 3   %d+%d @ %.0f GeV",NUMA,NUMB,ECM_NN);

char tOPIS[60];
if (ALPHA!=0.0)
sprintf(tOPIS,"mixed model with ALPHA=%.3f",ALPHA);
else
  if (PARTONS==0) sprintf(tOPIS,"wounded nucleon model");
  else sprintf(tOPIS,"wounded quark model");

Float_t x=0.40;
Float_t off1=0.85, off2=0.8;

TLatex *t1 = new TLatex();
t1->SetNDC();
t1->SetTextAlign(13);
   t1->SetTextFont(32);
   t1->SetTextColor(kBlack);
   t1->SetTextSizePixels(18);
   t1->SetTextAlign(12);
   t1->DrawLatex(x,off1,tEVENTS);
   t1->DrawLatex(x,off2,tOPIS);

   c1->Modified();
   c1->cd();
   c1->SetSelected(c1);

TLegend *leg = new TLegend(0.5,0.15,.8,0.3);
  leg->SetBorderSize(0);
  leg->AddEntry(hist_eps,  "#epsilon_{2}", "l");
  leg->AddEntry(hist_ep3s, "#epsilon_{3}", "l");
  leg->Draw("SAME");

c1->SaveAs("eps_dist.pdf");

}
