void b_dist(
            char const *p //!< name of the ROOT input file
                ){
gROOT->Reset();
gStyle->SetPalette(1);
gStyle->SetOptStat(0);

//TString empty("");
 char const *empty = "";

// Default file name
//TString inpfile("glissando.root");

 char const *inpfile = "glissando.root";
 if (p!=empty) inpfile = p;
 cout << "reads from: " << inpfile << endl;

 
TFile *f = new TFile(inpfile);
TTree *itree = (TTree*)f->Get("events");
TTree *param = (TTree*)f->Get("param"); 

Float_t b, BMIN, BMAX; 

itree->SetBranchAddress("b",&b);

param->SetBranchAddress("BMIN",&BMIN);param->GetEntry(0);
param->SetBranchAddress("BMAX",&BMAX);param->GetEntry(0);

TH1D *hist_b = new TH1D("hist_b","b distribution",40,BMIN,BMAX);

Int_t nentries = (Int_t)itree->GetEntries();

for (Int_t i=1; i<=nentries; i++) {
itree->GetEntry(i);
hist_b->Fill(b,1);
}

TCanvas *c1 = new TCanvas("c1","b distribution",500,300);

hist_b->GetXaxis()->SetLabelOffset(0.01);
hist_b->GetXaxis()->SetTitleSize(0.05);
hist_b->GetXaxis()->SetTitle("b[fm]");
hist_b->GetYaxis()->SetLabelOffset(0.008);
hist_b->GetYaxis()->SetTitleSize(0.055);
hist_b->GetYaxis()->SetTitle("N");
hist_b->Draw("HIST");

Int_t NUMA, NUMB;
Int_t PARTONS;
Float_t ECM_qq,ECM_NN,ALPHA;

TTree *param_NN = (TTree*)f->Get("param");

param_NN->SetBranchAddress("PARTONS",&PARTONS);param_NN->GetEntry(0);
param_NN->SetBranchAddress("NUMA",&NUMA);param_NN->GetEntry(0);
param_NN->SetBranchAddress("NUMB",&NUMB);param_NN->GetEntry(0);
param_NN->SetBranchAddress("ALPHA",&ALPHA);param_NN->GetEntry(0);

param_NN->SetBranchAddress("ECM",&ECM_NN);param_NN->GetEntry(0);

cout << "NN, center-of-mass-energy, sqrt(s_NN): " << ECM_NN << " GeV" << endl;

char tEVENTS0[60];
sprintf(tEVENTS0,"   GLISSANDO 3");

char tEVENTS[60];
sprintf(tEVENTS," %d+%d @ %.0f GeV",NUMA,NUMB,ECM_NN);

char tOPIS[60];
if (ALPHA!=0.0)
sprintf(tOPIS,"mixed model with ALPHA=%.3f",ALPHA);
else
  if (PARTONS==0) sprintf(tOPIS,"wounded nucleon model");
  else sprintf(tOPIS,"wounded quark model");

Float_t x=0.12, xA=0.6;
Float_t off1=0.87, off2=0.8;

TLatex *t1 = new TLatex();
t1->SetNDC();
t1->SetTextAlign(13);
   t1->SetTextFont(32);
   t1->SetTextColor(kBlack);
   t1->SetTextSizePixels(18);
   t1->SetTextAlign(12);
   t1->DrawLatex(x,off1,tEVENTS0);
   t1->DrawLatex(xA,off1,tEVENTS);
   t1->DrawLatex(x,off2,tOPIS);


c1->SaveAs("b_dist.pdf");

}
