#!/bin/bash

if [[ "$OSTYPE" == "linux-gnu"* ]]; then
        echo "linux"
        VIEW=evince
        
elif [[ "$OSTYPE" == "darwin"* ]]; then
        echo "Mac OSX, ROOT ver. 6.20.04 (Catalina)"
        export DYLD_LIBRARY_PATH=/Applications/root_v6.20.04/lib
        VIEW=open
fi

# init
function pause(){
   read -p "$*"
}

echo "Demo of new features of GLISSANDO 3"
pause "Press ENTER to start"

: <<'END'

echo "This block is commented out"
echo "you can move the line below to any locaton to comment out the commands in between"

END

# help

make

pause "Press ENTER to see the help"
./glissando3 -h

pause "Press ENTER to see the version"
./glissando3 -v


if [ ! -d "./output/demo_3" ]
then
    mkdir output/demo_3
fi

# running
QUESTION="Do you want to start this part of the script (yes/no) ?"

echo ""
echo "The p-p collisions in wounded nucleon and wounded quark models" 
echo "$QUESTION"

read ANSWER

if [[ "$ANSWER" == "yes" || "$ANSWER" == "YES" || "$ANSWER" == "y" || "$ANSWER" == "Y" ]]; then
make clean
make 'PREPROCESS =  -D_nnwp_=2 -D_bindep_=1 -D_files_=0 -D_profile_=1 -D_weight_=1 -D_evout_=0 -D_clusters_=0 -D_uncluster_=0 -D_partons_=0 -D_pardis_=0 -D_rdsconv_=1'

./glissando3 input/demo_3/pp.dat output/demo_3/ppN.root 2> err    

make clean
make 'PREPROCESS =  -D_nnwp_=1 -D_bindep_=1 -D_files_=0 -D_profile_=1 -D_weight_=1 -D_evout_=0 -D_clusters_=0 -D_uncluster_=0 -D_partons_=1 -D_pardis_=0 -D_rdsconv_=2'

./glissando3 input/demo_3/pp.dat output/demo_3/ppQ.root 2> err
./glissando3 input/demo_3/pp10.dat output/demo_3/ppQ10.root 2> err

cd output/demo_3   

root -b -l -q -x "../../macro/demo_3/inel_prof.C(\"ppN.root\",\"ppQ.root\",\"ppQ10.root\")" 
cp inel_prof.pdf inel_prof_N.pdf     
rm inel_prof.pdf
$VIEW inel_prof_N.pdf 2> err &

root -b -l -q -x "../../macro/demo_3/part_dist_pp.C(\"ppQ.root\")" 
$VIEW part_dist_pp.pdf 2> err &

root -b -l -q -x "../../macro/demo_3/rad_dis.C(\"ppQ.root\")" 
$VIEW rad_dis.pdf 2> err &


root -b -l -q -x "../../macro/demo_3/fourier_Q.C(\"ppQ.root\",10)" 
cp eps_23.pdf eps_23_ppQ.pdf
rm eps_23.pdf
$VIEW eps_23_ppQ.pdf 2> err &           

cd ../..

else
echo "Part of the script for the p-p collisions in wounded nucleon and wounded quark models is NOT EXECUTED"
fi
echo ""

echo "The p-p collisions in the wounded quark model + NB distribution"
echo "$QUESTION"

read ANSWER

if [[ "$ANSWER" == "yes" || "$ANSWER" == "YES" || "$ANSWER" == "y" || "$ANSWER" == "Y" ]]; then
make clean
make 'PREPROCESS =  -D_nnwp_=1 -D_bindep_=1 -D_files_=0 -D_profile_=1 -D_weight_=1 -D_evout_=0 -D_clusters_=0 -D_uncluster_=0 -D_partons_=1 -D_pardis_=0 -D_rdsconv_=2'

./glissando3 input/demo_3/pp_NB.dat output/demo_3/ppQ_NB.root 2> err    

cd output/demo_3   

root -b -l -q -x "../../macro/demo_3/mult_Q.C(\"ppQ_NB.root\")" 
$VIEW multi_Q.pdf 2> err &

cd ../..

else
echo "Part of the script for the p-p collisions in the wounded quark model + NB distribution is NOT EXECUTED"
fi
echo ""


echo "The p-Pb collisions in the wounded quark model + NB distribution"
echo "$QUESTION"

read ANSWER

if [[ "$ANSWER" == "yes" || "$ANSWER" == "YES" || "$ANSWER" == "y" || "$ANSWER" == "Y" ]]; then
make clean
make 'PREPROCESS =  -D_nnwp_=1 -D_bindep_=1 -D_files_=0 -D_profile_=0 -D_weight_=0 -D_evout_=0 -D_clusters_=0 -D_uncluster_=0 -D_partons_=1 -D_pardis_=0 -D_rdsconv_=2'

./glissando3 input/demo_3/pPb_NB.dat output/demo_3/pPbQ_NB.root 2> err    

cd output/demo_3   

root -b -l -q -x "../../macro/demo_3/mult_pPb_Q.C(\"pPbQ_NB.root\")" 
$VIEW multi_pPb_Q.pdf 2> err &

cd ../..

else
echo "Part of the script for the p-Pb collisions in the wounded quark model + NB distribution is NOT EXECUTED"
fi
echo ""

echo "The Au-Au collisions in the wounded quark model"
echo "$QUESTION"

read ANSWER

if [[ "$ANSWER" == "yes" || "$ANSWER" == "YES" || "$ANSWER" == "y" || "$ANSWER" == "Y" ]]; then
make clean
make 'PREPROCESS =  -D_nnwp_=1 -D_bindep_=1 -D_files_=0 -D_profile_=0 -D_weight_=0 -D_evout_=0 -D_clusters_=0 -D_uncluster_=0 -D_partons_=1 -D_pardis_=0 -D_rdsconv_=2'

./glissando3 input/demo_3/Au_part.dat output/demo_3/Au_part.root 2> err

cd output/demo_3

root -b -l -q -x "../../macro/demo_3/epsilon_c.C(\"Au_part.root\")" 
$VIEW epsilon_c.pdf 2> err &
$VIEW sigma_epsilon_c.pdf 2> err &

cd ../..

else
echo "Part of the script to run Au-Au collisions in the wounded quark model is NOT EXECUTED"
fi
echo ""


echo "The Au-Au collisions in the wounded nucleon model"
echo "$QUESTION"

read ANSWER

if [[ "$ANSWER" == "yes" || "$ANSWER" == "YES" || "$ANSWER" == "y" || "$ANSWER" == "Y" ]]; then
make clean
make 'PREPROCESS =  -D_nnwp_=2 -D_bindep_=1 -D_files_=0 -D_profile_=0 -D_weight_=0 -D_evout_=0 -D_clusters_=0 -D_uncluster_=0 -D_partons_=0 -D_pardis_=0 -D_rdsconv_=1'

./glissando3 input/demo_3/Au_nucl.dat output/demo_3/Au_nucl.root 2> err

cd output/demo_3
root -b -l -q -x "../../macro/demo_3/cent_comp.C(\"Au_part.root\",\"Au_nucl.root\")" 
$VIEW cent_comp.pdf 2> err &

root -b -l -q -x "../../macro/demo_3/w_prof_norm_AA.C(\"Au_part.root\",\"Au_nucl.root\")" 
$VIEW w_prof_norm_AA.pdf 2> err &

cd ../..

else
echo "Part of the script to run Au-Au collisions in the wounded nucleon model is NOT EXECUTED"
fi
echo ""


echo "The Pb-Pb collisions in the wounded nucleon model"
echo "$QUESTION"

read ANSWER

if [[ "$ANSWER" == "yes" || "$ANSWER" == "YES" || "$ANSWER" == "y" || "$ANSWER" == "Y" ]]; then
make clean
make 'PREPROCESS =  -D_nnwp_=2 -D_bindep_=1 -D_files_=0 -D_profile_=0 -D_weight_=0 -D_evout_=0 -D_clusters_=0 -D_uncluster_=0 -D_partons_=0 -D_pardis_=0 -D_rdsconv_=1'

./glissando3 input/demo_3/Pb_Pb.dat output/demo_3/Pb_Pb.root 2> err

else
echo "Part of the script to run Pb-Pb collisions in the wounded nucleon model is NOT EXECUTED"
fi
echo ""


echo "The 3He-Au collisions in the wounded quark model"
echo "$QUESTION"

read ANSWER

if [[ "$ANSWER" == "yes" || "$ANSWER" == "YES" || "$ANSWER" == "y" || "$ANSWER" == "Y" ]]; then
if [ -f "nucl/he3_plaintext.dat" ] ;
then
make clean
make 'PREPROCESS =  -D_nnwp_=1 -D_bindep_=1 -D_files_=1 -D_profile_=0 -D_weight_=0 -D_evout_=0 -D_clusters_=0 -D_uncluster_=0 -D_partons_=1 -D_pardis_=0 -D_rdsconv_=2'

./glissando3 input/demo_3/HeAu.dat output/demo_3/HeAu.root nucl/he3_plaintext.dat 2> err

cd output/demo_3
root -b -l -q -x "../../macro/demo_3/fourier_Q.C(\"HeAu.root\",40)" 
$VIEW eps_23.pdf 2> err &

cd ../..

else
echo "file nucl/he3_plaintext.dat does not exist! It may be downloaded from GLISSANDO website: http://www.ujk.edu.pl/homepages/mryb/GLISSANDO/"
fi

else
echo "Part of the script to run 3He-Au collisions in the wounded quark model is NOT EXECUTED"
fi
echo ""

echo "The collisions with clustered nuclei"
echo "$QUESTION"

read ANSWER

if [[ "$ANSWER" == "yes" || "$ANSWER" == "YES" || "$ANSWER" == "y" || "$ANSWER" == "Y" ]]; then
make clean
make 'PREPROCESS =  -D_nnwp_=2 -D_bindep_=1 -D_files_=0 -D_profile_=1 -D_weight_=0 -D_evout_=0 -D_clusters_=1 -D_uncluster_=0 -D_partons_=0 -D_pardis_=0 -D_rdsconv_=1'

./glissando3 input/demo_3/Be7_Be7.dat output/demo_3/Be7_Be7.root 2> err
./glissando3 input/demo_3/Be9_Be9.dat output/demo_3/Be9_Be9.root 2> err
./glissando3 input/demo_3/C12_C12.dat output/demo_3/C12_C12.root 2> err
./glissando3 input/demo_3/O16_O16.dat output/demo_3/O16_O16.root 2> err

cd output/demo_3
root -b -l -q -x "../../macro/demo_3/clusters.C(\"Be7_Be7.root\")" 
cp clusters.pdf clusters_Be7.pdf
$VIEW clusters_Be7.pdf 2> err &
root -b -l -q -x "../../macro/demo_3/clusters.C(\"Be9_Be9.root\")" 
cp clusters.pdf clusters_Be9.pdf
$VIEW clusters_Be9.pdf 2> err &
root -b -l -q -x "../../macro/demo_3/clusters.C(\"C12_C12.root\")" 
cp clusters.pdf clusters_C12.pdf
$VIEW clusters_C12.pdf 2> err &
root -b -l -q -x "../../macro/demo_3/clusters.C(\"O16_O16.root\")" 
cp clusters.pdf clusters_O16.pdf
rm clusters.pdf
$VIEW clusters_O16.pdf 2> err &

cd ../..

else
echo "Part of the script to run collisions with clustered nuclei is NOT EXECUTED"
fi
echo ""

echo "The comparison for 12C-197Au collisions in with clustered and uniform 12C distributions"
echo "$QUESTION"

read ANSWER

if [[ "$ANSWER" == "yes" || "$ANSWER" == "YES" || "$ANSWER" == "y" || "$ANSWER" == "Y" ]]; then
make clean
make 'PREPROCESS =  -D_nnwp_=2 -D_bindep_=1 -D_files_=0 -D_profile_=1 -D_weight_=0 -D_evout_=0 -D_clusters_=1 -D_uncluster_=0 -D_partons_=0 -D_pardis_=0 -D_rdsconv_=1'

./glissando3 input/demo_3/C12_Au.dat output/demo_3/C12_Au_cl.root 2> err

make clean
make 'PREPROCESS =  -D_nnwp_=2 -D_bindep_=1 -D_files_=0 -D_profile_=1 -D_weight_=0 -D_evout_=0 -D_clusters_=1 -D_uncluster_=1 -D_partons_=0 -D_pardis_=0 -D_rdsconv_=1'

./glissando3 input/demo_3/C12_Au.dat output/demo_3/C12_Au_uni.root 2> err

cd output/demo_3
root -b -l -q -x "../../macro/demo_3/sc_comp.C(\"C12_Au_cl.root\",\"C12_Au_uni.root\")" 
$VIEW sc_comp.pdf 2> err &

cd ../..

else
echo "Part of the script to compare of 12C-197Au collisions in with clustered and uniform 12C distribution is NOT EXECUTED"
fi
echo ""


echo "The generation of a sample text output"
echo "$QUESTION"

read ANSWER

if [[ "$ANSWER" == "yes" || "$ANSWER" == "YES" || "$ANSWER" == "y" || "$ANSWER" == "Y" ]]; then
make clean
make 'PREPROCESS =  -D_nnwp_=2 -D_bindep_=1 -D_files_=0 -D_profile_=0 -D_weight_=0 -D_evout_=2 -D_clusters_=1 -D_uncluster_=0 -D_partons_=0 -D_pardis_=0 -D_rdsconv_=1'

./glissando3 input/demo_3/Be7_Be7.dat output/demo_3/Be7_Be7.root 2> err

else
echo "Part of the script to generate a sample text output is NOT EXECUTED"
fi
echo ""

echo "Demo of functionality of GLISSANDO 3 completed!"
