#!/bin/bash

if [[ "$OSTYPE" == "linux-gnu"* ]]; then
        echo "linux"
        VIEW=evince
        
elif [[ "$OSTYPE" == "darwin"* ]]; then
        echo "Mac OSX, ROOT ver. 6.20.04 (Catalina)"
        export DYLD_LIBRARY_PATH=/Applications/root_v6.20.04/lib
        VIEW=open
fi

# fix for Catalina
VIEW=open
# init
function pause(){
   read -p "$*"
}

echo "Tutorial how to determine centrality in GLISSANDO 3"
pause "Press ENTER to start"

: <<'END'

echo "This block is commented out"
echo " you can move the line below to any locaton to comment out the commands in between"

END

# running
QUESTION="Do you want to start this part of the script (yes/no) ?"

echo ""
echo "The Pb-Pb collisions in the wounded nucleon model"
echo "$QUESTION"

read ANSWER

if [[ "$ANSWER" == "yes" || "$ANSWER" == "YES" || "$ANSWER" == "y" || "$ANSWER" == "Y" ]]; then
make clean
make 'PREPROCESS = -D_debug_=0 -D_nnwp_=2 -D_bindep_=1 -D_files_=0 -D_profile_=0 -D_weight_=0 -D_evout_=0 -D_clusters_=0 -D_uncluster_=0 -D_partons_=0 -D_pardis_=0 -D_rdsconv_=1'

./glissando3 input/demo_3/Pb_Pb.dat output/demo_3/Pb_Pb.root 2> err

cd output/demo_3
root -b -l -q -x "../../macro/demo_3/cent.C(\"Pb_Pb.root\")" 
$VIEW cen.pdf 2> err &

echo "Examine output/demo_3/centrality.dat and modify input/demo_3/Pb_Pb_2030_all_b.dat accordingly"

cd ../..

else
echo "Part of the script for the Pb-Pb collisions in the wounded nucleon model is NOT EXECUTED"
fi
echo ""


echo "The Pb-Pb collisions in the wounded nucleon model for c=20-30%"
echo "$QUESTION"

read ANSWER

if [[ "$ANSWER" == "yes" || "$ANSWER" == "YES" || "$ANSWER" == "y" || "$ANSWER" == "Y" ]]; then
make clean
make 'PREPROCESS = -D_debug_=0 -D_nnwp_=2 -D_bindep_=1 -D_files_=0 -D_profile_=0 -D_weight_=0 -D_evout_=0 -D_clusters_=0 -D_uncluster_=0 -D_partons_=0 -D_pardis_=0 -D_rdsconv_=1'

./glissando3 input/demo_3/Pb_Pb_2030_all_b.dat output/demo_3/Pb_Pb_2030_all_b.root 2> err

cd output/demo_3
root -b -l -q -x "../../macro/demo_3/b_dist.C(\"Pb_Pb_2030_all_b.root\")" 
$VIEW b_dist.pdf 2> err &

echo "Examine the range in output/demo_3/b_dist.pdf and modify BMIN and BMAX in input/demo_3/Pb_Pb_2030_b.dat accordingly"

cd ../..
 
else
echo "Part of the script for the Pb-Pb collisions in the wounded nucleon model for c=20-30% is NOT EXECUTED"
fi
echo ""



echo "The Pb-Pb collisions in the wounded nucleon model for c=20-30% with restricted b"
echo "$QUESTION"

read ANSWER

if [[ "$ANSWER" == "yes" || "$ANSWER" == "YES" || "$ANSWER" == "y" || "$ANSWER" == "Y" ]]; then
./glissando3 input/demo_3/Pb_Pb_2030_b.dat output/demo_3/Pb_Pb_2030_b.root 2> err

cd output/demo_3
root -b -l -q -x "../../macro/demo_3/b_dist.C(\"Pb_Pb_2030_b.root\")" 
$VIEW b_dist.pdf 2> err &

root -b -l -q -x "../../macro/demo_3/eps_dist.C(\"Pb_Pb_2030_b.root\")" 
$VIEW eps_dist.pdf 2> err &

cd ../..

else
echo "Part of the script for the Pb-Pb collisions in the wounded nucleon model for c=20-30% with restricted b is NOT EXECUTED"
fi
echo ""


echo "Completed!"
