#!/bin/bash

# you may replace the postscript viewer with your favorite one
VIEW=gv

# init
function pause(){
   read -p "$*"
}

# complile with _profile_ precompiler option to show deformation

make clean
make 'PREPROCESS = -D_gauss_=1 -D_files_=0 -D_profile_=1 -D_weight_=0 -D_rapidity_=0'

# running

pause "Press ENTER to see the help"
./glissando2 -h

pause "Press ENTER to see the version"
./glissando2 -v

pause "Press ENTER to run the version showing r-cos(theta) profile for deformed and spherical U, Au and 63Cu nuclei"
./glissando2 input/input_minbias_UU_mixed_deformed_norot.dat output/output_minbias_UU_mixed_deformed_norot.root 2> err
./glissando2 input/input_minbias_UU_mixed_spherical_norot.dat output/output_minbias_UU_mixed_spherical_norot.root 2> err
./glissando2 input/input_minbias_AuAu_mixed_deformed_norot.dat output/output_minbias_AuAu_mixed_deformed_norot.root 2> err
./glissando2 input/input_minbias_AuAu_mixed_spherical_norot.dat output/output_minbias_AuAu_mixed_spherical_norot.root 2> err
./glissando2 input/input_minbias_Cu63Cu63_mixed_deformed_norot.dat output/output_minbias_Cu63Cu63_mixed_deformed_norot.root 2> err
./glissando2 input/input_minbias_Cu63Cu63_mixed_spherical_norot.dat output/output_minbias_Cu63Cu63_mixed_spherical_norot.root 2> err

cd output 
root -b -l -q -x "../macro/profile2_deformation_U.C(\"output_minbias_UU_mixed_deformed_norot.root\",\"output_minbias_UU_mixed_spherical_norot.root\")"
root -b -l -q -x "../macro/profile2_deformation_Au.C(\"output_minbias_AuAu_mixed_deformed_norot.root\",\"output_minbias_AuAu_mixed_spherical_norot.root\")"
root -b -l -q -x "../macro/profile2_deformation_63Cu.C(\"output_minbias_Cu63Cu63_mixed_deformed_norot.root\",\"output_minbias_Cu63Cu63_mixed_spherical_norot.root\")"
