(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     43159,        938]
NotebookOptionsPosition[     41921,        893]
NotebookOutlinePosition[     42257,        908]
CellTagsIndexPosition[     42214,        905]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Profile folding", "Title",
 CellChangeTimes->{{3.401773885858439*^9, 3.401773968199986*^9}}],

Cell[TextData[{
 StyleBox["GLISSANDO - GLauber Initial State Simulation AND mOre ..., ver.1.0",
  FontSize->16],
 "       "
}], "Text",
 CellChangeTimes->{{3.401780989389159*^9, 3.401781207071295*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"the", " ", "Woods"}], "-", 
    RowBox[{"Saxon", " ", "profile"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"fWS", "[", 
    RowBox[{"r_", ",", "R_", ",", "a_"}], "]"}], "=", 
   RowBox[{
    RowBox[{"c", "/", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"Exp", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"r", "-", "R"}], ")"}], "/", "a"}], "]"}]}], ")"}]}], "/.", 
    RowBox[{"c", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "1"}], "/", 
      RowBox[{"(", 
       RowBox[{"8", "Pi", " ", 
        RowBox[{"a", "^", "3"}], " ", 
        RowBox[{"PolyLog", "[", 
         RowBox[{"3", ",", 
          RowBox[{"-", 
           RowBox[{"Exp", "[", 
            RowBox[{"R", "/", "a"}], "]"}]}]}], "]"}]}], 
       ")"}]}]}]}]}]}]], "Input",
 CellChangeTimes->{{3.401197610515625*^9, 3.40119761946875*^9}, {
  3.40124921090625*^9, 3.40124922646875*^9}, {3.401771496714348*^9, 
  3.401771509466106*^9}, {3.401771566334811*^9, 3.401771570146654*^9}, {
  3.401772099038551*^9, 3.401772102655533*^9}, {3.40177414430665*^9, 
  3.401774145994113*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{"-", 
   FractionBox["1", 
    RowBox[{"8", " ", "\[Pi]", " ", 
     SuperscriptBox["a", "3"], " ", 
     TemplateBox[{"3",RowBox[{"-", 
         SuperscriptBox["\[ExponentialE]", 
          FractionBox["R", "a"]]}]},
      "PolyLog"], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        FractionBox[
         RowBox[{"r", "-", "R"}], "a"]], "+", "1"}], ")"}]}]]}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{3.491961099147232*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"nucleon", " ", "profile"}], " ", "-", " ", "gaussian"}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"fN", "[", 
    RowBox[{"r_", ",", "s_"}], "]"}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "Pi", " ", 
         RowBox[{"s", "^", "2"}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"3", "/", "2"}], ")"}]}]}], 
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"r", "^", "2"}]}], "/", 
       RowBox[{"(", 
        RowBox[{"2", 
         RowBox[{"s", "^", "2"}]}], ")"}]}], "]"}]}], "//", 
    "PowerExpand"}]}]}]], "Input",
 CellChangeTimes->{{3.4011967818125*^9, 3.401196798328125*^9}, {
  3.401196856921875*^9, 3.401196880421875*^9}, {3.401242776640625*^9, 
  3.40124279265625*^9}, {3.401250179109375*^9, 3.4012501828125*^9}, {
  3.401771560848659*^9, 3.401771583743762*^9}}],

Cell[BoxData[
 FormBox[
  FractionBox[
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox["r", "2"], 
      RowBox[{"2", " ", 
       SuperscriptBox["s", "2"]}]]}]], 
   RowBox[{"2", " ", 
    SqrtBox["2"], " ", 
    SuperscriptBox["\[Pi]", 
     RowBox[{"3", "/", "2"}]], " ", 
    SuperscriptBox["s", "3"]}]], TraditionalForm]], "Output",
 CellChangeTimes->{3.491961102292412*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"0.79", " ", "is", " ", "the", " ", "nucleon", " ", "I"}], "=", 
    RowBox[{"0", " ", "rms", " ", "charge", " ", "radis"}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"s0", "=", 
    RowBox[{".79", "/", 
     RowBox[{"Sqrt", "[", "3", "]"}]}]}], ";"}]}]], "Input",
 CellChangeTimes->{{3.401243534703125*^9, 3.401243556109375*^9}, {
   3.401243944609375*^9, 3.40124397684375*^9}, 3.40124422025*^9, 
   3.401771631938753*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"superposition", ":", " ", 
    RowBox[{"azimuthal", " ", "integral"}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"au", "[", 
    RowBox[{"r_", ",", "rho_", ",", "R_", ",", "a_", ",", "s_"}], "]"}], "=", 
   RowBox[{
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"fWS", "[", 
        RowBox[{"r", ",", "R", ",", "a"}], "]"}], 
       RowBox[{"fN", "[", 
        RowBox[{
         RowBox[{"Sqrt", "[", 
          RowBox[{
           RowBox[{"rho", "^", "2"}], "+", 
           RowBox[{"r", "^", "2"}], " ", "-", 
           RowBox[{"2", " ", "rho", " ", "r", " ", "z"}]}], "]"}], ",", "s"}],
         "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", 
        RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}], "//", 
    "PowerExpand"}]}]}]], "Input",
 CellChangeTimes->{{3.401196893078125*^9, 3.4011969813125*^9}, {
  3.401197030984375*^9, 3.40119703203125*^9}, {3.40119728065625*^9, 
  3.401197283375*^9}, {3.401197341046875*^9, 3.401197380453125*^9}, {
  3.4012491455*^9, 3.40124916425*^9}, {3.401771733390981*^9, 
  3.401771768981902*^9}, {3.40177416310772*^9, 3.401774164602501*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{"-", 
   FractionBox[
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"-", 
       FractionBox[
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"r", "+", "rho"}], ")"}], "2"], 
        RowBox[{"2", " ", 
         SuperscriptBox["s", "2"]}]]}]], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        FractionBox[
         RowBox[{"2", " ", "r", " ", "rho"}], 
         SuperscriptBox["s", "2"]]], "-", "1"}], ")"}]}], 
    RowBox[{"16", " ", 
     SqrtBox["2"], " ", 
     SuperscriptBox["\[Pi]", 
      RowBox[{"5", "/", "2"}]], " ", 
     SuperscriptBox["a", "3"], " ", "r", " ", "rho", " ", "s", " ", 
     TemplateBox[{"3",RowBox[{"-", 
         SuperscriptBox["\[ExponentialE]", 
          FractionBox["R", "a"]]}]},
      "PolyLog"], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        FractionBox[
         RowBox[{"r", "-", "R"}], "a"]], "+", "1"}], ")"}]}]]}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{3.491961117957894*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"superposition", ":", " ", 
    RowBox[{"radial", " ", "integral"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"fe", "[", 
    RowBox[{"rho_", ",", "R_", ",", "a_", ",", "s_"}], "]"}], ":=", 
   RowBox[{"2", "Pi", " ", 
    RowBox[{"NIntegrate", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"au", "[", 
        RowBox[{"r", ",", "rho", ",", "R", ",", "a", ",", "s"}], "]"}], " ", 
       RowBox[{"r", "^", "2"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"r", ",", "0", ",", "Infinity"}], "}"}]}], 
     "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.40119703409375*^9, 3.40119704790625*^9}, {
   3.40119708309375*^9, 3.401197085484375*^9}, 3.40119714853125*^9, {
   3.401197230390625*^9, 3.401197327171875*^9}, {3.40119738525*^9, 
   3.401197393265625*^9}, {3.401242079484375*^9, 3.401242080609375*^9}, {
   3.401242449796875*^9, 3.401242501609375*^9}, {3.4012480928125*^9, 
   3.40124810090625*^9}, {3.401248928671875*^9, 3.401248931546875*^9}, {
   3.401249171078125*^9, 3.401249183875*^9}, {3.401771772662149*^9, 
   3.401771834115128*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"the", " ", "Woods"}], "-", 
    RowBox[{"Saxon", " ", "parameters", " ", "for", " ", "e"}], "-", 
    RowBox[{"nucleus", " ", "scattering"}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"R", "[", "A_", "]"}], "=", 
     RowBox[{
      RowBox[{"1.12", " ", 
       RowBox[{"A", "^", 
        RowBox[{"(", 
         RowBox[{"1", "/", "3"}], ")"}]}]}], "-", 
      RowBox[{"0.86", " ", 
       RowBox[{"A", "^", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "/", "3"}], ")"}]}]}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Rc", "[", "A_", "]"}], "=", 
     RowBox[{
      RowBox[{"1.12", " ", 
       RowBox[{"A", "^", 
        RowBox[{"(", 
         RowBox[{"1", "/", "3"}], ")"}]}]}], "-", 
      RowBox[{"0.622", " ", 
       RowBox[{"A", "^", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "/", "3"}], ")"}]}]}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"A1", "=", "208"}], "\[IndentingNewLine]", 
   RowBox[{"Rel", "=", 
    RowBox[{"R", "[", "A1", "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Rc1", "=", 
    RowBox[{"Rc", "[", "A1", "]"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ael", "=", "0.54"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ac1", "=", "0.46"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.40177224479502*^9, 3.401772254758728*^9}, {
  3.401772285087462*^9, 3.401772291697346*^9}, {3.401774054266442*^9, 
  3.40177408217417*^9}, {3.491961293641692*^9, 3.491961376859537*^9}, {
  3.491961444441091*^9, 3.491961534938224*^9}, {3.491961565093689*^9, 
  3.491961597620656*^9}, {3.491961632831917*^9, 3.491961680014516*^9}, {
  3.49196176331298*^9, 3.491961768002452*^9}}],

Cell[BoxData[
 FormBox["208", TraditionalForm]], "Output",
 CellChangeTimes->{{3.49196134758384*^9, 3.491961378931194*^9}, {
   3.491961575705269*^9, 3.491961599279963*^9}, {3.491961637300703*^9, 
   3.491961681371872*^9}, 3.491961769406984*^9}],

Cell[BoxData[
 FormBox["6.490843321278989`", TraditionalForm]], "Output",
 CellChangeTimes->{{3.49196134758384*^9, 3.491961378931194*^9}, {
   3.491961575705269*^9, 3.491961599279963*^9}, {3.491961637300703*^9, 
   3.491961681371872*^9}, 3.491961769413772*^9}],

Cell[BoxData[
 FormBox["6.53101215095915`", TraditionalForm]], "Output",
 CellChangeTimes->{{3.49196134758384*^9, 3.491961378931194*^9}, {
   3.491961575705269*^9, 3.491961599279963*^9}, {3.491961637300703*^9, 
   3.491961681371872*^9}, 3.491961769578199*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"fWS", "[", 
      RowBox[{"rho", ",", "Rel", ",", "ael"}], "]"}], ",", 
     RowBox[{"fe", "[", 
      RowBox[{"rho", ",", "Rc1", ",", "ac1", ",", "s0"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"rho", ",", "0", ",", "9"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"RGBColor", "[", 
       RowBox[{"0", ",", "0", ",", "1"}], "]"}], ",", 
      RowBox[{"RGBColor", "[", 
       RowBox[{"1", ",", "0", ",", "0"}], "]"}]}], "}"}]}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<\[Rho] [fm]\>\"", ",", "profile"}], "}"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.401772331520994*^9, 3.401772369771269*^9}, {
  3.401772400274344*^9, 3.401772440972726*^9}, {3.40177248438924*^9, 
  3.401772508097377*^9}, {3.401772572235684*^9, 3.401772575548483*^9}, {
  3.401774085953549*^9, 3.401774126167951*^9}, {3.401774189060284*^9, 
  3.401774206776109*^9}, {3.401774375379599*^9, 3.401774422691971*^9}, {
  3.491961137710049*^9, 3.491961140405865*^9}, {3.49196160793189*^9, 
  3.491961617127977*^9}}],

Cell[BoxData[
 FormBox[
  GraphicsBox[{{}, {}, 
    {RGBColor[0, 0, 1], LineBox[CompressedData["
1:eJwV13c8lV8cB3B7b/ci694rRYhSotJzvmTdm1IZlRRNZEtIQpHIzkhJkYoi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      "]]}, 
    {RGBColor[1, 0, 0], LineBox[CompressedData["
1:eJwV13k41E8YAPB15j7XzdpFEkWIFH3nrZxLSqQS6ZIjOSNJOZKU3CWKKJWz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      "]]}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->True,
   AxesLabel->{
     FormBox["\"\[Rho] [fm]\"", TraditionalForm], 
     FormBox["profile", TraditionalForm]},
   AxesOrigin->{0, 0},
   PlotRange->{{0, 9}, {0., 0.000817161785127439}},
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]}], TraditionalForm]], "Output",
 CellChangeTimes->{
  3.491961153033189*^9, {3.491961622539664*^9, 3.491961691876139*^9}, 
   3.491961778629502*^9},
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell["\<\
The overlapping curves show, that the foldind is indeed a gaussian with \
modified parameters.\
\>", "Text",
 CellChangeTimes->{{3.401781274440864*^9, 3.401781347151409*^9}},
 FontSize->16,
 FontColor->RGBColor[1, 0, 0]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"function", " ", "to", " ", "be", " ", "minimized"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"g", "[", 
    RowBox[{"R_", ",", "a_"}], "]"}], ":=", 
   RowBox[{"NIntegrate", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"fe", "[", 
         RowBox[{"rho", ",", "R", ",", "a", ",", "s0"}], "]"}], "-", 
        RowBox[{"fWS", "[", 
         RowBox[{"rho", ",", "Rel", ",", "ael"}], "]"}]}], ")"}], "^", "2"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"rho", ",", "0", ",", "10"}], "}"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.40124204275*^9, 3.40124206371875*^9}, {
  3.40124211978125*^9, 3.4012421974375*^9}, {3.401242405125*^9, 
  3.40124242571875*^9}, {3.40124253821875*^9, 3.401242542625*^9}, {
  3.401244000390625*^9, 3.401244008796875*^9}, {3.40124418159375*^9, 
  3.40124418215625*^9}, {3.401244430875*^9, 3.401244443625*^9}, {
  3.401249240421875*^9, 3.401249281125*^9}, {3.401265380677835*^9, 
  3.401265382738993*^9}, {3.401265448878135*^9, 3.401265449999763*^9}, {
  3.401771942835497*^9, 3.401771958734706*^9}, {3.401772003714535*^9, 
  3.401772068002984*^9}, {3.401772236104894*^9, 3.401772268549077*^9}, {
  3.401772311158064*^9, 3.401772315998477*^9}, {3.401772422262472*^9, 
  3.401772423034238*^9}, {3.401772517780729*^9, 3.401772518355558*^9}, {
  3.401774227017801*^9, 3.401774228275718*^9}, {3.491962077970257*^9, 
  3.491962084411515*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"THIS", " ", "TAKES", " ", "A", " ", "FEW", " ", 
    RowBox[{"MINUTES", "!"}], " ", "Minimum", " ", "can", " ", "read", " ", 
    "off", " ", "from", " ", "the", " ", "plot"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"Timing", "[", 
   RowBox[{"ContourPlot", "[", 
    RowBox[{
     RowBox[{"g", "[", 
      RowBox[{"R", ",", "a"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"R", ",", "6.39", ",", "6.43"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", ".44", ",", ".48"}], "}"}], ",", 
     RowBox[{"PlotPoints", "\[Rule]", "15"}], ",", 
     RowBox[{"Contours", "\[Rule]", "50"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGAQBWIQzcCw/VtU+EtHBgbbPxCaXzEaTC+A0A3fvCF8R18I
f0oghF4CpWOiIfK8sRC+dzqEvyIdqq4NQv/qhoirrIPQxhC6gWsLhL8DQjfM
PgCh1xyAqrsNobnvQ8RXP4Hwj0LpSW8h4tafIPxHTDFgvi4LmGZobILw89sh
fEPlODB/rgqEXuUAphmmOIFoxslM39OAtNCmhJ8gOpQj72RsxEvHTxWbToPo
2A9+aXFAWlQzFUzfP/L8byKQfmll8B9EAwDbKYqX
  "]],

Cell["\<\
The location of minimum, R and a, should be reproduced by the script fitr.C \
on the data from  GLISSANDO\
\>", "Text",
 CellChangeTimes->{{3.401781274440864*^9, 3.401781347151409*^9}},
 FontSize->16,
 FontColor->RGBColor[1, 0, 0]]
}, Open  ]]
},
WindowSize->{820, 630},
WindowMargins->{{Automatic, 0}, {Automatic, 61}},
FrontEndVersion->"7.0 for Linux x86 (32-bit) (February 25, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 98, 1, 85, "Title"],
Cell[668, 25, 201, 5, 36, "Text"],
Cell[CellGroupData[{
Cell[894, 34, 1171, 33, 55, "Input"],
Cell[2068, 69, 511, 16, 72, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2616, 90, 975, 29, 55, "Input"],
Cell[3594, 121, 426, 14, 74, "Output"]
}, Open  ]],
Cell[4035, 138, 515, 13, 55, "Input"],
Cell[CellGroupData[{
Cell[4575, 155, 1203, 31, 77, "Input"],
Cell[5781, 188, 1086, 34, 104, "Output"]
}, Open  ]],
Cell[6882, 225, 1124, 25, 55, "Input"],
Cell[CellGroupData[{
Cell[8031, 254, 1825, 51, 187, "Input"],
Cell[9859, 307, 245, 4, 32, "Output"],
Cell[10107, 313, 260, 4, 32, "Output"],
Cell[10370, 319, 259, 4, 32, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10666, 328, 1181, 28, 55, "Input"],
Cell[11850, 358, 27050, 455, 221, 19929, 336, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]],
Cell[38915, 816, 230, 6, 61, "Text"],
Cell[39148, 824, 1489, 32, 55, "Input"],
Cell[40640, 858, 1021, 24, 77, "Input"],
Cell[41664, 884, 241, 6, 61, "Text"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
