(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      8912,        206]*)
(*NotebookOutlinePosition[      9591,        229]*)
(*  CellTagsIndexPosition[      9547,        225]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Profile folding", "Title",
  CellChangeTimes -> {{3.401773885858439*^9, 3.401773968199986*^9}}],

Cell[TextData[{
  StyleBox["GLISSANDO - GLauber Initial State Simulation AND mOre ..., \
ver.1.0",
    FontSize->16],
  "       "
}], "Text",
  CellChangeTimes -> {{3.401780989389159*^9, 3.401781207071295*^9}}],

Cell[BoxData[
    \(\(\( (*\ 
      the\ Woods - Saxon\ profile\ *) \)\(\[IndentingNewLine]\)\(fWS[r_, R_, 
        a_] = c/\((1 + Exp[\((r - R)\)/a])\) /. 
        c \[Rule] \(-1\)/\((8  
                Pi\ a^3\ PolyLog[3, \(-Exp[R/a]\)])\)\)\)\)], "Input",
  CellChangeTimes -> {{3.401197610515625*^9, 3.40119761946875*^9}, \
{3.40124921090625*^9, 3.40124922646875*^9}, {3.401771496714348*^9, \
3.401771509466106*^9}, {3.401771566334811*^9, 3.401771570146654*^9}, \
{3.401772099038551*^9, 3.401772102655533*^9}, {3.40177414430665*^9, \
3.401774145994113*^9}}],

Cell[BoxData[
    \(\(\( (*\ 
      nucleon\ profile\  - \ gaussian\ *) \)\(\[IndentingNewLine]\)\(fN[r_, 
        s_] = 1/\((2  Pi\ s^2)\)^\((3/2)\) Exp[\(-r^2\)/\((2  s^2)\)] // 
        PowerExpand\)\)\)], "Input",
  CellChangeTimes -> {{3.4011967818125*^9, 3.401196798328125*^9}, \
{3.401196856921875*^9, 3.401196880421875*^9}, {3.401242776640625*^9, \
3.40124279265625*^9}, {3.401250179109375*^9, 3.4012501828125*^9}, \
{3.401771560848659*^9, 3.401771583743762*^9}}],

Cell[BoxData[
    \(\(\( (*\ 
      0.79\ is\ the\ nucleon\ I = 
        0\ rms\ charge\ radis\ *) \)\(\[IndentingNewLine]\)\(s0 =  .79/
          Sqrt[3];\)\)\)], "Input",
  CellChangeTimes -> {{3.401243534703125*^9, 3.401243556109375*^9}, \
{3.401243944609375*^9, 3.40124397684375*^9}, 3.40124422025*^9, \
3.401771631938753*^9}],

Cell[BoxData[
    \(\(\( (*\ 
      superposition : \ azimuthal\ integral\ *) \)\(\[IndentingNewLine]\)\(au[
        r_, rho_, R_, a_, s_] = 
      Integrate[
          fWS[r, R, a] fN[Sqrt[rho^2 + r^2\  - 2\ rho\ r\ z], s], {z, \(-1\), 
            1}] // PowerExpand\)\)\)], "Input",
  CellChangeTimes -> {{3.401196893078125*^9, 3.4011969813125*^9}, \
{3.401197030984375*^9, 3.40119703203125*^9}, {3.40119728065625*^9, \
3.401197283375*^9}, {3.401197341046875*^9, 3.401197380453125*^9}, \
{3.4012491455*^9, 3.40124916425*^9}, {3.401771733390981*^9, \
3.401771768981902*^9}, {3.40177416310772*^9, 3.401774164602501*^9}}],

Cell[BoxData[
    \(\(\( (*\ 
      superposition : \ radial\ integral\ *) \)\(\[IndentingNewLine]\)\(fe[
        rho_, R_, a_, s_] := 
      2  Pi\ NIntegrate[
          au[r, rho, R, a, s]\ r^2, {r, 0, Infinity}]\)\)\)], "Input",
  CellChangeTimes -> {{3.40119703409375*^9, 3.40119704790625*^9}, \
{3.40119708309375*^9, 3.401197085484375*^9}, 3.40119714853125*^9, \
{3.401197230390625*^9, 3.401197327171875*^9}, {3.40119738525*^9, \
3.401197393265625*^9}, {3.401242079484375*^9, 3.401242080609375*^9}, \
{3.401242449796875*^9, 3.401242501609375*^9}, {3.4012480928125*^9, \
3.40124810090625*^9}, {3.401248928671875*^9, 3.401248931546875*^9}, \
{3.401249171078125*^9, 3.401249183875*^9}, {3.401771772662149*^9, \
3.401771834115128*^9}}],

Cell[BoxData[
    \(\(\( (*\ 
      the\ Woods - Saxon\ parameters\ for\ e - 
        nucleus\ scattering\ *) \)\(\[IndentingNewLine]\)\(Rel = 6.37; 
    ael = 0.54;\)\)\)], "Input",
  CellChangeTimes -> {{3.40177224479502*^9, 3.401772254758728*^9}, \
{3.401772285087462*^9, 3.401772291697346*^9}, {3.401774054266442*^9, \
3.40177408217417*^9}}],

Cell[BoxData[
    \(\(\( (*\ 
      comparison\ of\ the\ Woods - 
        Saxon\ profile\ fWS\ and\ the\ folded\ profile\ fe\ \
\[IndentingNewLine]The\ plot\ shows\ that\ folding\ of\ Woods - 
        Saxon\ with\ Gaussaian\ is\ to\ \[IndentingNewLine]\ \ a\ vety\ good\ \
approximation\ a\ Woods\ Saxon\ with\ adjusted\ parameters\ *) \)\(\ \)\(\
\[IndentingNewLine]\)\(Plot[{fWS[rho, Rel, ael], 
          fe[rho, 6.41, 0.46, s0]}, {rho, 0, 9}, 
        PlotStyle \[Rule] {RGBColor[0, 0, 1], RGBColor[1, 0, 0]}, 
        AxesLabel \[Rule] {"\<\[Rho] [fm]\>", profile}];\)\)\)], "Input",
  CellChangeTimes -> {{3.401772331520994*^9, 3.401772369771269*^9}, \
{3.401772400274344*^9, 3.401772440972726*^9}, {3.40177248438924*^9, \
3.401772508097377*^9}, {3.401772572235684*^9, 3.401772575548483*^9}, \
{3.401774085953549*^9, 3.401774126167951*^9}, {3.401774189060284*^9, \
3.401774206776109*^9}, {3.401774375379599*^9, 3.401774422691971*^9}}],

Cell["\<\
The overlapping curves show, that the foldind is indeed a gaussian with \
modified parameters.\
\>", "Text",
  CellChangeTimes -> {{3.401781274440864*^9, 3.401781347151409*^9}},
  FontSize->16,
  FontColor->RGBColor[1, 0, 0]],

Cell[BoxData[
    \(\(\( (*\ 
      function\ to\ be\ minimized\ *) \)\(\[IndentingNewLine]\)\(g[R_, a_] := 
      NIntegrate[\((fe[rho, R, a, s0] - fWS[rho, Rel, ael])\)^2, {rho, 0, 
          Infinity}]\)\)\)], "Input",
  CellChangeTimes -> {{3.40124204275*^9, 3.40124206371875*^9}, \
{3.40124211978125*^9, 3.4012421974375*^9}, {3.401242405125*^9, \
3.40124242571875*^9}, {3.40124253821875*^9, 3.401242542625*^9}, \
{3.401244000390625*^9, 3.401244008796875*^9}, {3.40124418159375*^9, \
3.40124418215625*^9}, {3.401244430875*^9, 3.401244443625*^9}, \
{3.401249240421875*^9, 3.401249281125*^9}, {3.401265380677835*^9, \
3.401265382738993*^9}, {3.401265448878135*^9, 3.401265449999763*^9}, \
{3.401771942835497*^9, 3.401771958734706*^9}, {3.401772003714535*^9, \
3.401772068002984*^9}, {3.401772236104894*^9, 3.401772268549077*^9}, \
{3.401772311158064*^9, 3.401772315998477*^9}, {3.401772422262472*^9, \
3.401772423034238*^9}, {3.401772517780729*^9, 3.401772518355558*^9}, \
{3.401774227017801*^9, 3.401774228275718*^9}}],

Cell[BoxData[
    \(\(\( (*\ 
      THIS\ TAKES\ A\ FEW\ \(MINUTES!\)\ Minimum\ can\ read\ off\ from\ the\ \
plot\ *) \)\(\[IndentingNewLine]\)\(Timing[
      ContourPlot[g[R, a], {R, 6.39, 6.43}, {a,  .44,  .48}, 
        PlotPoints \[Rule] 15, Contours \[Rule] 50]]\)\)\)], "Input",
  CellChangeTimes -> {{3.40124254971875*^9, 3.40124259390625*^9}, \
{3.40124288846875*^9, 3.401242893*^9}, {3.401243231703125*^9, \
3.40124324203125*^9}, {3.401243276640625*^9, 3.401243277140625*^9}, \
{3.401243354890625*^9, 3.40124336840625*^9}, {3.401243450359375*^9, \
3.40124345325*^9}, {3.401243701140625*^9, 3.401243743828125*^9}, \
{3.401244017125*^9, 3.40124401759375*^9}, {3.401244064328125*^9, \
3.40124406975*^9}, {3.401244164859375*^9, 3.401244165390625*^9}, \
{3.40124437759375*^9, 3.40124440834375*^9}, {3.401244453359375*^9, \
3.40124445415625*^9}, {3.4012445245625*^9, 3.401244561859375*^9}, \
{3.4012446950625*^9, 3.401244705421875*^9}, {3.40124571603125*^9, \
3.401245755484375*^9}, {3.40124904953125*^9, 3.401249060921875*^9}, \
{3.401249285328125*^9, 3.401249300625*^9}, {3.401267128080445*^9, \
3.401267147021737*^9}, {3.401772619438517*^9, 3.401772637577264*^9}, \
{3.401773874466841*^9, 3.401773875161265*^9}, {3.401781231242782*^9, \
3.401781241507191*^9}}],

Cell["\<\
The location of minimum, R and a, should be reproduced by the script fitr.C \
on the data from  GLISSANDO\
\>", "Text",
  CellChangeTimes -> {{3.401781274440864*^9, 3.401781347151409*^9}},
  FontSize->16,
  FontColor->RGBColor[1, 0, 0]]
}, Open  ]]
},
FrontEndVersion->"5.2 for Microsoft Windows",
ScreenRectangle->{{0, 1280}, {0, 702}},
WindowSize->{820, 630},
WindowMargins->{{53, Automatic}, {-2, Automatic}},
StyleDefinitions -> "Default.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 101, 1, 95, "Title"],
Cell[1880, 56, 210, 6, 37, "Text"],
Cell[2093, 64, 562, 10, 50, "Input"],
Cell[2658, 76, 471, 8, 50, "Input"],
Cell[3132, 86, 330, 7, 50, "Input"],
Cell[3465, 95, 621, 11, 70, "Input"],
Cell[4089, 108, 736, 13, 50, "Input"],
Cell[4828, 123, 345, 7, 50, "Input"],
Cell[5176, 132, 940, 15, 110, "Input"],
Cell[6119, 149, 235, 6, 37, "Text"],
Cell[6357, 157, 1021, 16, 50, "Input"],
Cell[7381, 175, 1266, 20, 50, "Input"],
Cell[8650, 197, 246, 6, 37, "Text"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

