#include "label.C"

// Produces plot of disperssions of the x and y locations of sources
// as a function of number of wounded nucleons.
void dxdy(char *p) {

gROOT->Reset();

TString empty("");

// Default file name
TString inpfile("glissando.root");
 if (p!=empty) inpfile = p;
 cout << "reads from: " << inpfile << endl;;  

TFile *f = new TFile(inpfile);

TH1D *h = ((TH1D*)f->Get("nx2")); 
int ima=(h->GetNbinsX());

for (int i=1;i<=ima;i++) {
float v =(h->GetBinContent(i));
if (v>0){
h->SetBinContent(i,sqrt(v));
}else{
h->SetBinContent(i,0.0);
}
}


int reb;
//reb=1 - number of bins as in original histigram
//reb=x - x times smaller number of bins
cout << "give rebinning parameter (small natural number): ";
cin >> reb;
cout << endl;

TH1D *hnew = (TH1D*)h -> Rebin(reb,"hnew");
hnew -> Scale(1./reb);

TCanvas *c2 = new TCanvas("c2","dxdy",650,600);
c2->cd(1);
c2->Range(0,0,25,18);
c2->SetFillColor(0);
label(inpfile);

pad2 = new TPad("pad2","This is pad2",0.02,0.02,0.98,0.78,33);
pad2->Draw();
pad2->cd();
pad2->Range(-0.255174,-19.25,2.29657,-6.75);

gPad->SetFillStyle(4000);
gPad->SetFillColor(0);

hnew->SetStats(kFALSE);

hnew->Draw();

TH1D *hp = (TH1D*)f->Get("ny2"); 
int imap=(hp->GetNbinsX());

for (int i=1;i<=imap;i++) {
float vp =(hp->GetBinContent(i));

if (vp>0){
hp->SetBinContent(i,sqrt(vp));
}else{
hp->SetBinContent(i,0.0);
}
}

TH1D *hnewp = (TH1D*)hp -> Rebin(reb,"hnewp");
hnewp -> Scale(1./reb);

hnew->SetTitle("");
hnew->SetXTitle("N_{w}");
hnew->GetXaxis()->SetLabelSize(0.04);
hnew->GetYaxis()->SetLabelSize(0.04);
hnew->GetXaxis()->SetTitleSize(0.05);
hnew->GetYaxis()->SetTitleSize(0.05);
hnew->GetXaxis()->SetTitleOffset(0.8);
hnew->GetYaxis()->SetTitleOffset(0.8);

hnew->GetYaxis()->SetRangeUser(0.,1.0);
hnew->SetYTitle("#Delta x, #Delta y  [fm]  ");
hnew->SetLineColor(4);
hnewp->SetLineColor(2);
hnew->SetLineStyle(2);

hnewp->Draw("SAME");

TLegend *leg = new TLegend(0.4,0.7,0.55,0.8);
  leg->AddEntry(hnew, "#Delta x", "l");
  leg->AddEntry(hnewp, "#Delta y", "l");
  leg->Draw("SAME");

c2->SaveAs("dxdy.eps");

}
