#include "label.C"

// Woods-Saxon function
Double_t saxon(Double_t *x, Double_t *par) {
return 
4.0*TMath::Pi()*x[0]*x[0]*par[0]/(1.0+TMath::Exp((x[0]-par[1])/par[2]));
}

// Produces the nuclear density profile and its Woods-Saxon fit.
// The script works on Root files generated with lissando_profile.exe
void fitr(char *p) {

gROOT->Reset();

TString empty("");

// Default file name
TString inpfile("glissando.root");
 if (p!=empty) inpfile = p;
 cout << "reads from: " << inpfile << endl;;  

TFile *f = new TFile(inpfile);
//TFile *hfile = new TFile("rr.root","RECREATE","histfile");

TTree *density = (TTree*)f->Get("density");
TTree *param =  (TTree*)f->Get("param");
float r;
int NUMA;
float RWSA,AWSA;
density->SetBranchAddress("r",&r);
param->SetBranchAddress("NUMA",&NUMA);param->GetEntry(0);
param->SetBranchAddress("RWSA",&RWSA);param->GetEntry(0);
param->SetBranchAddress("AWSA",&AWSA);param->GetEntry(0);

cout << "Mass number=" << NUMA << ", original WS parameters: R=" << RWSA <<
   " a=" << AWSA <<endl << endl;


TH1F *hr = new TH1F("hr","radial distribution",200,0,14);

//read all entries and fill the histograms
Int_t nentries = (Int_t)density->GetEntries();
for (Int_t i=0; i<nentries; i++) {
density->GetEntry(i);
hr->Fill(r);
}

//hfile->Write();
//hfile->Close();
//f->Close("R");

    const int np = 100;
    Double_t x[np],ex[np],par[np];
    gStyle->SetOptFit(0000);
    gStyle->SetOptStat("");
//    TFile *f = new TFile("rr.root");
  
    TCanvas *c2 = new TCanvas("c2","WS",650,600);
    c2->cd(1);
    c2->Range(0,0,25,18);
    c2->SetFillColor(0);
    
    label_fit(inpfile);
   
pad2 = new TPad("pad2","This is pad2",0.02,0.02,0.98,0.78,33);
pad2->Draw();
pad2->cd();
pad2->Range(-0.255174,-19.25,2.29657,-6.75);
gPad->SetFillStyle(4000);
gPad->SetFillColor(0);


//TH1F *k1 = (TH1F *)f->Get("hr");
hr->SetTitle("");
hr->SetMarkerStyle(21);
hr->SetStats(kFALSE);
hr->SetMarkerSize(0.5);
hr->Draw("E");  

TF1 *func = new TF1("saxon",saxon,0.0,10.0,3);
func->SetParameters(500,5,0.5);
func->SetParNames("Norm","R","a");
    
func->SetNpx(500);
func->SetLineWidth(1);
func->SetLineColor(kBlue);

hr->Fit(func,"r");
hr->Fit(func,"REM");

    hr->Draw("E");
    func->Draw("SAME");

TF1 *fitpar=hr->GetFunction(saxon);
float p0=fitpar->GetParameter(0);
float e0=fitpar->GetParError(0);
float p1=fitpar->GetParameter(1);
float e1=fitpar->GetParError(1);
float p2=fitpar->GetParameter(2);
float e2=fitpar->GetParError(2);


char optr[300];
char opta[300];

sprintf(optr,"R = %.4f #pm %.4f",p1,e1);
sprintf(opta,"a = %.4f #pm %.4f",p2,e2);

TLatex *t = new TLatex();
   t->SetNDC();
   t->SetTextFont(32);
   t->SetTextColor(1);
   t->SetTextSize(0.05);
   t->SetTextAlign(12);
   t->DrawLatex(.6,.85,optr);
   t->DrawLatex(.6,.8,opta);

c2->SaveAs("fitr.eps");
}
