
void label(char *inpfile){

gROOT->Reset();

TFile *f = new TFile(inpfile);
TTree *param =  (TTree*)f->Get("param");

       int EVENTS,          // number of generated events (gold: 10000 = 1 min.)
           NBIN,            // number of bins for histogramming
           NUMA,            // mass number of nucleus A
           NUMB,            // mass number of nucleus B
           WMIN,            // minimum number of wounded nucleons to record event
           MODEL,           // switch for the superimposed distribution: 0 - uniform, 1 - Poisson, 2 - Gamma
           W0,              // minimum allowed number of wounded nucleons
           W1,              // maximum allowed number of wounded nucleons
           SHIFT,           // 1 - shift the coordinates of the fireball to c.m. in the fixed-axes case, 0 - do not
           RET;             // 0 - fix-last algorithm, 1 - return-to-beginning algorithm for nuclear density

        UInt_t ISEED;       // seed for the ROOT random number generator, if 0 - random seed generated

       float BMIN,             // minimal impact parameter
             BMAX,             // maximal impact parameter
	     WEI0,             // minimum allowed weight
             WEI1,             // maximum allowed weight
             RWSA,             // Woods-Saxon radius - standard case gold
             AWSA,             // Woods-Saxon width  - standard case gold
             RWSB,             // Woods-Saxon radius - standard case gold
             AWSB,             // Woods-Saxon width  - standard case gold
	     WF,               // the w parameter in the Fermi distribution

             BTOT,             // size parameter for histogramming

             SNN,              // NN "wounding" cross section in millibarns
             SBIN,             // NN binary cross section in millibarns
             ALPHA,            // 0 - wounded, 1 - binary, 0.145 - mixed (PHOBOS)
             Uw,               // Poisson or Gamma parameters for wounded
             Ubin,             // and binary
             CD,               // closest allowed distance between nucleons in the nucleus in fm (simulation of repulsion)
             DW,               // dispersion of the location of the source for wounded nucleons (in fm)
             DBIN,             // dispersion of the location of the source for binary collisions (in fm)
             ver;              // version of the model

           param->SetBranchAddress("EVENTS",&EVENTS); param->GetEntry(0);
           param->SetBranchAddress("NBIN",&NBIN);param->GetEntry(0);
           param->SetBranchAddress("NUMA",&NUMA);param->GetEntry(0);
           param->SetBranchAddress("NUMB",&NUMB);param->GetEntry(0);
           param->SetBranchAddress("WMIN",&WMIN);param->GetEntry(0);
           param->SetBranchAddress("MODEL",&MODEL);param->GetEntry(0);
           param->SetBranchAddress("W0",&W0);param->GetEntry(0);
           param->SetBranchAddress("W1",&W1);param->GetEntry(0);
           param->SetBranchAddress("WEI0",&WEI0);param->GetEntry(0);
           param->SetBranchAddress("WEI1",&WEI1);param->GetEntry(0);
	   param->SetBranchAddress("ISEED",&ISEED);param->GetEntry(0);
           param->SetBranchAddress("BMIN",&BMIN);param->GetEntry(0);
           param->SetBranchAddress("BMAX",&BMAX);param->GetEntry(0);
           param->SetBranchAddress("BTOT",&BTOT);param->GetEntry(0);
           param->SetBranchAddress("RWSA",&RWSA);param->GetEntry(0);
           param->SetBranchAddress("AWSA",&AWSA);param->GetEntry(0);
           param->SetBranchAddress("RWSB",&RWSB);param->GetEntry(0);
           param->SetBranchAddress("AWSB",&AWSB);param->GetEntry(0);
	   param->SetBranchAddress("WF",&WF);param->GetEntry(0);
           param->SetBranchAddress("SNN",&SNN);param->GetEntry(0);
           param->SetBranchAddress("SBIN",&SBIN);param->GetEntry(0);
           param->SetBranchAddress("ALPHA",&ALPHA);param->GetEntry(0);
           param->SetBranchAddress("Uw",&Uw);param->GetEntry(0);
           param->SetBranchAddress("Ubin",&Ubin);param->GetEntry(0);
           param->SetBranchAddress("CD",&CD);param->GetEntry(0);
           param->SetBranchAddress("SHIFT",&SHIFT);param->GetEntry(0);
           param->SetBranchAddress("RET",&RET);param->GetEntry(0);
	   param->SetBranchAddress("DW",&DW);param->GetEntry(0);
           param->SetBranchAddress("DBIN",&DBIN);param->GetEntry(0);
           param->SetBranchAddress("ver",&ver);param->GetEntry(0);


char tVER[30],tEVENTS[30],tB[30],tB1[30],tNw[30],tnpa[30];
char tWNM[200],tMIXED[200],tHOTSPOT[200],tPOISSON[200],tGAMMA[200],tPOISSON1[200],tGAMMA1[200];
char tdisp[30],tdisp1[30];

sprintf(tVER,"GLISSANDO ver.  %.1f ",ver);
sprintf(tEVENTS,"%d+%d, %d events ",NUMA,NUMB,EVENTS);
sprintf(tB,"b=%.1f - %.1f fm ",BMIN,BMAX);
sprintf(tB1,"b=%.1f fm ",BMIN);
sprintf(tNw,"N_{w}=%d - %d,  ",W0,W1);
sprintf(tnpa,"weight=%.1f  ",WEI1);
sprintf(tdisp,"DW=%.1f fm, DBIN=%.1f fm  ",DW,DBIN);
sprintf(tdisp1,"DW=%.1f fm, DBIN=%.1f fm, WF=%.1f  ",DW,DBIN,WF);

sprintf(tWNM,"wounded nucleon model: #sigma_{w}= %.1f mb ",SNN);
sprintf(tMIXED,"mixed model: #sigma_{w}= %.1f mb, #sigma_{bin}=%.1f mb, #alpha=%.3f ",SNN,SBIN,ALPHA);
sprintf(tHOTSPOT,"mixed model with hotspots: #sigma_{w}=%.1f mb, #sigma_{bin}=%.1f mb, #alpha=%.3f ",SNN,SBIN,ALPHA);
sprintf(tPOISSON,"overlayed Poisson distribution with parameters U_{w}=%.1f (wounded) and U_{bin}=%.1f (binary)",Uw,Ubin);
sprintf(tPOISSON1,"overlayed Poisson distribution with parameters U_{w}=%.1f (wounded)",Uw);
sprintf(tGAMMA,"overlayed Gamma distribution with parameters U_{w}=%.1f (wounded) and U_{bin}=%.1f (binary)",Uw,Ubin);
sprintf(tGAMMA1,"overlayed Gamma distribution with parameters U_{w}=%.1f (wounded)",Uw);

float x=0.25;

TLatex *t1 = new TLatex();
   t1->SetTextFont(32);
   t1->SetTextColor(1);
   t1->SetTextSize(0.03);
   t1->SetTextAlign(12);

   t1->DrawLatex(x,17.8,tVER);
   t1->DrawLatex(x,17.0,tEVENTS);

//   if (((W0==4)&&(W1==1000))||((WEI0==4)&&(WEI0==10000))){
   if(BMIN==BMAX){
     t1->DrawLatex(x,16.5,tB1);}
   else {
     t1->DrawLatex(x,16.5,tB);}
    //}
   if(WF==0.0){
      t1->DrawLatex(x,16.0,tdisp);}
   else {
      t1->DrawLatex(x,16.0,tdisp1);}
   if((W0!=4)||(W1!=1000)) t1->DrawLatex(x,15.5,tNw);
   if((WEI0!=4)||(WEI1!=10000)) {
   float xx=4.;
   if (!((W0!=4)||(W1!=1000))) xx=0.; 
   t1->DrawLatex(x+xx,15.5,tnpa);
   }  
   if(ALPHA==0) t1->DrawLatex(x,15.0,tWNM);
   if((ALPHA>0) &&(SBIN>=SNN)) t1->DrawLatex(x,15.0,tMIXED);
   if((ALPHA>0) &&(SBIN<SNN))  t1->DrawLatex(x,15.0,tHOTSPOT);
   if((ALPHA>0)&&(MODEL==1)) t1->DrawLatex(x,14.5,tPOISSON);
   if((ALPHA==0)&&(MODEL==1)) t1->DrawLatex(x,14.5,tPOISSON1);
   if((ALPHA>0)&&(MODEL==2)) t1->DrawLatex(x,14.5,tGAMMA);
   if((ALPHA==0)&&(MODEL==2)) t1->DrawLatex(x,14.5,tGAMMA1);
f->Close("R");

}


void label_fit(char *inpfile){

gROOT->Reset();

TFile *f = new TFile(inpfile);
TTree *param =  (TTree*)f->Get("param");

       int EVENTS,          // number of generated events (gold: 10000 = 1 min.)
           NBIN,            // number of bins for histogramming
           NUMA,            // mass number of nucleus A
           NUMB,            // mass number of nucleus B
           WMIN,            // minimum number of wounded nucleons to record event
           MODEL,           // switch for the superimposed distribution: 0 - uniform, 1 - Poisson, 2 - Gamma
           W0,              // minimum allowed number of wounded nucleons
           W1,              // maximum allowed number of wounded nucleons
           SHIFT,           // 1 - shift the coordinates of the fireball to c.m. in the fixed-axes case, 0 - do not
           RET;             // 0 - fix-last algorithm, 1 - return-to-beginning algorithm for nuclear density

        UInt_t ISEED;       // seed for the ROOT random number generator, if 0 - random seed generated

       float BMIN,             // minimal impact parameter
             BMAX,             // maximal impact parameter
	     WEI0,             // minimum allowed weight
             WEI1,             // maximum allowed weight
             RWSA,             // Woods-Saxon radius - standard case gold
             AWSA,             // Woods-Saxon width  - standard case gold
             RWSB,             // Woods-Saxon radius - standard case gold
             AWSB,             // Woods-Saxon width  - standard case gold
	     WF,               // the w parameter in the Fermi distribution

             BTOT,             // size parameter for histogramming

             SNN,              // NN "wounding" cross section in millibarns
             SBIN,             // NN binary cross section in millibarns
             ALPHA,            // 0 - wounded, 1 - binary, 0.145 - mixed (PHOBOS)
             Uw,               // Poisson or Gamma parameters for wounded
             Ubin,             // and binary
             CD,               // closest allowed distance between nucleons in the nucleus in fm (simulation of repulsion)
             DW,               // dispersion of the location of the source for wounded nucleons (in fm)
             DBIN,             // dispersion of the location of the source for binary collisions (in fm)
             ver;              // version of the model

           param->SetBranchAddress("EVENTS",&EVENTS); param->GetEntry(0);
           param->SetBranchAddress("NBIN",&NBIN);param->GetEntry(0);
           param->SetBranchAddress("NUMA",&NUMA);param->GetEntry(0);
           param->SetBranchAddress("NUMB",&NUMB);param->GetEntry(0);
           param->SetBranchAddress("WMIN",&WMIN);param->GetEntry(0);
           param->SetBranchAddress("MODEL",&MODEL);param->GetEntry(0);
           param->SetBranchAddress("W0",&W0);param->GetEntry(0);
           param->SetBranchAddress("W1",&W1);param->GetEntry(0);
           param->SetBranchAddress("WEI0",&WEI0);param->GetEntry(0);
           param->SetBranchAddress("WEI1",&WEI1);param->GetEntry(0);
	   param->SetBranchAddress("ISEED",&ISEED);param->GetEntry(0);
           param->SetBranchAddress("BMIN",&BMIN);param->GetEntry(0);
           param->SetBranchAddress("BMAX",&BMAX);param->GetEntry(0);
           param->SetBranchAddress("BTOT",&BTOT);param->GetEntry(0);
           param->SetBranchAddress("RWSA",&RWSA);param->GetEntry(0);
           param->SetBranchAddress("AWSA",&AWSA);param->GetEntry(0);
           param->SetBranchAddress("RWSB",&RWSB);param->GetEntry(0);
           param->SetBranchAddress("AWSB",&AWSB);param->GetEntry(0);
	   param->SetBranchAddress("WF",&WF);param->GetEntry(0);
           param->SetBranchAddress("SNN",&SNN);param->GetEntry(0);
           param->SetBranchAddress("SBIN",&SBIN);param->GetEntry(0);
           param->SetBranchAddress("ALPHA",&ALPHA);param->GetEntry(0);
           param->SetBranchAddress("Uw",&Uw);param->GetEntry(0);
           param->SetBranchAddress("Ubin",&Ubin);param->GetEntry(0);
           param->SetBranchAddress("CD",&CD);param->GetEntry(0);
           param->SetBranchAddress("SHIFT",&SHIFT);param->GetEntry(0);
           param->SetBranchAddress("RET",&RET);param->GetEntry(0);
	   param->SetBranchAddress("DW",&DW);param->GetEntry(0);
           param->SetBranchAddress("DBIN",&DBIN);param->GetEntry(0);
           param->SetBranchAddress("ver",&ver);param->GetEntry(0);


char tVER[30],tNUC[30];

sprintf(tVER,"GLISSANDO ver.  %.1f ",ver);
sprintf(tNUC,"A=%d",NUMA);

float x=0.25;

TLatex *t1 = new TLatex();
   t1->SetTextFont(32);
   t1->SetTextColor(1);
   t1->SetTextSize(0.03);
   t1->SetTextAlign(12);

   t1->DrawLatex(x,17.8,tVER);
   t1->DrawLatex(x,17.0,tNUC);
   t1->DrawLatex(x,16.5,"WS fit to distribution of centers of nucleons");
f->Close("R");

}
