#include "label.C"

// Produces plots of the mean and scaled standard deviation 
// of the deformation parameters
// as a function of number of wounded nucleons
void epsilon(char *p) {

TString empty("");

// Default file name
TString inpfile("glissando.root");
 if (p!=empty) inpfile = p;
 cout << "reads from: " << inpfile << endl;;  

TFile *f = new TFile(inpfile);

TH1D *h = ((TH1D*)f->Get("neps2")); 
TAxis *xaxis = h->GetXaxis();

TAxis *xaxis = h->GetXaxis();
int ima=(xaxis->GetNbins());
float ima_w=(xaxis->GetBinWidth(1));

float zas=ima_w*ima;

for (int i=1;i<=ima;i++) {
float v =(h->GetBinContent(i));
if (v>0){
h->SetBinContent(i,sqrt(v));
}else{
h->SetBinContent(i,0.0);
}
}


int reb;
//reb=1 - number of bins as in original histigram
//reb=x - x times smaller number of bins
cout << "give rebinning parameter: ";
cin >> reb;
cout << endl;

TH1D *hnew = (TH1D*)h -> Rebin(reb,"hnew");
hnew -> Scale(1./reb);

float label_size=0.04;
float title_size=0.05;
float title_offset=0.8;

TCanvas *c2 = new TCanvas("c2","sigma epsilon",650,600);
c2->cd(1);
c2->Range(0,0,25,18);
c2->SetFillColor(0);
label(inpfile);

pad2 = new TPad("pad2","This is pad2",0.02,0.02,0.98,0.78,33);
pad2->Draw();
pad2->cd();
pad2->Range(-0.255174,-19.25,2.29657,-6.75);
gPad->SetFillStyle(4000);
gPad->SetFillColor(29);

hnew->SetStats(kFALSE);

hnew->Draw();

TH1D *hp = (TH1D*)f->Get("nepsp2"); 
int imap=(hp->GetNbinsX());

for (int i=1;i<=imap;i++) {
float vp =(hp->GetBinContent(i));

if (vp>0){
hp->SetBinContent(i,sqrt(vp));
}else{
hp->SetBinContent(i,0.0);
}
}

TH1D *hnewp = (TH1D*)hp -> Rebin(reb,"hnewp");
hnewp -> Scale(1./reb);

hnew->SetTitle("");
hnew->SetXTitle("N_{w}");
hnew->GetXaxis()->SetLabelSize(label_size);
hnew->GetYaxis()->SetLabelSize(label_size);
hnew->GetXaxis()->SetTitleSize(title_size);
hnew->GetYaxis()->SetTitleSize(title_size);
hnew->GetXaxis()->SetTitleOffset(title_offset);
hnew->GetYaxis()->SetTitleOffset(title_offset);
hnew->GetYaxis()->SetRangeUser(0.,1.5);
hnew->SetYTitle("#Delta#epsilon/#epsilon, #Delta#epsilon*/#epsilon*    ");
hnew->SetLineColor(4);
hnewp->SetLineColor(2);
hnew->SetLineStyle(2);

hnewp->Draw("SAME");

float ymax=sqrt(4/3.14159265-1);
float start=0.75*zas;
TLine *liml = new TLine(start,ymax,zas,ymax);
liml->Draw("SAME");

TLegend *leg = new TLegend(0.2,0.7,0.35,0.8);
  leg->AddEntry(hnew, "#Delta#epsilon/#epsilon", "l");
  leg->AddEntry(hnewp, "#Delta#epsilon*/#epsilon*", "l");
  leg->Draw("SAME");

c2->SaveAs("sigma_epsilon.eps");

TH1D *heps = ((TH1D*)f->Get("neps")); 
TH1D *hepsnew = (TH1D*)heps -> Rebin(reb,"hepsnew");
hepsnew -> Scale(1./reb);

hepsnew->SetStats(kFALSE);

TCanvas *c4 = new TCanvas("c4","epsilon",650,600);
 c4->cd(1);
 c4->Range(0,0,25,18);
 c4->SetFillColor(0);
 label(inpfile);

pad2 = new TPad("pad2","This is pad2",0.02,0.02,0.98,0.78,33);
pad2->Draw();
pad2->cd();
pad2->Range(-0.255174,-19.25,2.29657,-6.75);
gPad->SetFillStyle(4000);
gPad->SetFillColor(29);

hepsnew->Draw();

TH1D *hpeps = (TH1D*)f->Get("nepsp"); 

TH1D *hpepsnew = (TH1D*)hpeps -> Rebin(reb,"hpepsnew");
hpepsnew -> Scale(1./reb);

hepsnew->SetTitle("");
hepsnew->SetXTitle("N_{w}");
hepsnew->GetXaxis()->SetLabelSize(label_size);
hepsnew->GetYaxis()->SetLabelSize(label_size);
hepsnew->GetXaxis()->SetTitleSize(title_size);
hepsnew->GetYaxis()->SetTitleSize(title_size);
hepsnew->GetXaxis()->SetTitleOffset(title_offset);
hepsnew->GetYaxis()->SetTitleOffset(title_offset);
hepsnew->GetYaxis()->SetRangeUser(0,0.8);
hepsnew->SetYTitle("#epsilon, #epsilon*    ");
hpepsnew->SetLineColor(2);
hepsnew->SetLineColor(4);
hepsnew->SetLineStyle(2);

hpepsnew->Draw("SAME");

TLegend *legeps = new TLegend(0.2,0.7,0.35,0.8);
  legeps->AddEntry(hepsnew, "#epsilon", "l");
  legeps->AddEntry(hpepsnew, "#epsilon*", "l");
  legeps->Draw("SAME");

c4->SaveAs("epsilon.eps");

}
