/** \file sc_comp.C
 * (part of GLISSANDO 3)
*/

//#include "label.C"

//! generates the plot of the symmetric cumulant SC(2,3)
/* Useful for flow analysis */

void sc_comp(
        char const *p_clust,
        char const *p_unif
            ){ //!< names of the ROOT input files

TString empty("");

// Default file name
//TString inpfile_unif("glissando.root");
char const *inpfile_unif = "glissando.root";

 if (p_unif!=empty) inpfile_unif = p_unif;
 cout << "reads from: " << inpfile_unif << endl;;  

//TString inpfile_clust("glissando.root");
char const *inpfile_clust = "glissando.root";
if (p_clust!=empty) inpfile_clust = p_clust;
cout << "reads from: " << inpfile_clust << endl;;  
 
TFile *f_unif  = new TFile(inpfile_unif);
TFile *f_clust = new TFile(inpfile_clust);

// set the limits for Nw (this correspond to centality selection) 
Int_t nlow=10, nup=2000;

//set the rebinning parameter
Int_t reb;
cout << "Warning: this script makes sense for the minimum-bias case" << endl;
cout << "Give the rebinning parameter (a small natural number): "<< endl;
cin >> reb;
cout << endl;

Float_t hmax=1800;
Float_t hmaxreb=hmax;

//set the upper limits for the epsilon histograms and the number of bins for the first plot
Float_t eps_lim=1, eps_lim2=4;
Int_t eps_steps=100;

TCanvas *canvas = new TCanvas("canvas", "Symmetric cumulant",176,88,890,609);
gStyle->SetOptStat(0);
canvas->SetHighLightColor(2);
canvas->Range(-1.053539,-1.288352,0.8277803,1.288352);
canvas->SetFillColor(0);
canvas->SetFillStyle(4000);
canvas->SetBorderMode(0);
canvas->SetBorderSize(2);
canvas->SetTheta(35.26678);
canvas->SetPhi(30.40632);
canvas->SetLeftMargin(0.14);
canvas->SetRightMargin(0.02);
canvas->SetTopMargin(0.14);
canvas->SetBottomMargin(0.14);
canvas->SetFrameBorderMode(0);

Float_t eps, eps3, nwAB, ECM_unif, ECM_clust;
Int_t NUMA,NUMB;

TTree *param_unif = (TTree*)f_unif->Get("param");
param_unif->SetBranchAddress("ECM",&ECM_unif);param_unif->GetEntry(0);
param_unif->SetBranchAddress("NUMA",&NUMA);param_unif->GetEntry(0);
param_unif->SetBranchAddress("NUMB",&NUMB);param_unif->GetEntry(0);

TTree *param_clust = (TTree*)f_clust->Get("param");
param_clust->SetBranchAddress("ECM",&ECM_clust);param_clust->GetEntry(0);
//if(ECM_unif!=ECM_clust) {cout << " Different cm energies!" << endl; exit(0);}

TTree *events_unif = (TTree*)f_unif->Get("events");
// nwAB is actually RDS (npa)
events_unif->SetBranchAddress("npa",&nwAB);
events_unif->SetBranchAddress("eps",&eps);
events_unif->SetBranchAddress("ep3s",&eps3);

Int_t nentries_unif = (Int_t)events_unif->GetEntries();
TH1D * huni_unif     = new TH1D("huni_unif",    "huni_unif",    hmaxreb, 0.5, hmax+.5);
TH1D * hepsn_unif    = new TH1D("hepsn_unif",   "hepsn_unif",   hmaxreb, 0.5, hmax+.5);
TH1D * hepsnt_unif   = new TH1D("hepsnt_unif",  "hepsnt_unif",  hmaxreb, 0.5, hmax+.5);
TH1D * hepsn2_unif   = new TH1D("hepsn2_unif",  "hepsn2_unif",  hmaxreb, 0.5, hmax+.5);
TH1D * hepsnt2_unif  = new TH1D("hepsnt2_unif", "hepsnt2_unif", hmaxreb, 0.5, hmax+.5);
TH1D * hepsn4_unif   = new TH1D("hepsn4_unif",  "hepsn4_unif",  hmaxreb, 0.5, hmax+.5);
TH1D * hepsnt4_unif  = new TH1D("hepsnt4_unif", "hepsnt4_unif", hmaxreb, 0.5, hmax+.5);
TH1D * hepscor_unif  = new TH1D("hepscor_unif", "hepscor_unif", hmaxreb, 0.5, hmax+.5);
TH1D * hepssc_unif   = new TH1D("hepssc_unif",  "hepssc_unif",  hmaxreb, 0.5, hmax+.5);
TH1D * hepscov2_unif = new TH1D("hepscov2_unif","hepscov2_unif",hmaxreb, 0.5, hmax+.5);


for (Int_t i=0;i<nentries_unif;i++){
    events_unif  -> GetEntry(i);
    huni_unif    -> Fill(nwAB,1);
    hepsn_unif   -> Fill(nwAB,eps);
    hepsnt_unif  -> Fill(nwAB,eps3);
    hepsn2_unif  -> Fill(nwAB,eps*eps);
    hepsnt2_unif -> Fill(nwAB,eps3*eps3);
    hepsn4_unif  -> Fill(nwAB,eps*eps*eps*eps);
    hepsnt4_unif -> Fill(nwAB,eps3*eps3*eps3*eps3);
    hepscor_unif -> Fill(nwAB,eps*eps3);
    hepssc_unif  -> Fill(nwAB,eps*eps*eps3*eps3);
}

hepsn_unif->Divide(huni_unif);
hepsnt_unif->Divide(huni_unif);
hepsn2_unif->Divide(huni_unif);
hepsnt2_unif->Divide(huni_unif);
hepsn4_unif->Divide(huni_unif);
hepsnt4_unif->Divide(huni_unif);
hepscor_unif->Divide(huni_unif);
hepssc_unif->Divide(huni_unif);


for (Int_t i=1;i<=hmaxreb;i++) {
    Float_t vp_unif =(hepsn_unif->GetBinContent(i));
    Float_t vp2_unif =(hepsn2_unif->GetBinContent(i));
    Float_t vp4_unif =(hepsn4_unif->GetBinContent(i));
    Float_t vpt_unif =(hepsnt_unif->GetBinContent(i));
    Float_t vpt2_unif =(hepsnt2_unif->GetBinContent(i));
    Float_t vpt4_unif =(hepsnt4_unif->GetBinContent(i));
    Float_t vcor_unif =(hepscor_unif->GetBinContent(i));
    Float_t vcor2_unif =(hepssc_unif->GetBinContent(i));
    
    if(vp2_unif>0 && vpt2_unif>0){
        hepscov2_unif->SetBinContent(i,(vcor2_unif-vp2_unif*vpt2_unif)/(vp2_unif*vpt2_unif));        
    };
}


/****************************************/

TAxis *xaxis_unif = hepscov2_unif->GetXaxis();
Int_t ima_unif=(xaxis_unif->GetNbins());
Float_t ima_w_unif=(xaxis_unif->GetBinWidth(1));
Float_t zas_unif=ima_w_unif*ima_unif;
Float_t sc_unif=(huni_unif->Integral());

Int_t  binnum_unif = ima_unif; 
Float_t bins_unif[1800];
bins_unif[0]=0;

//! determination of centrality bins
for (Int_t i=1;i<=ima_unif;i++) {
    bins_unif[i]=bins_unif[i-1]+(huni_unif->GetBinContent(ima_unif-i+1))/sc_unif;    
};

TH1D* hc_unif = new TH1D("n_unif","hc_unif", binnum_unif, bins_unif);

for (Int_t i=1;i<=ima_unif;i++) {
    Float_t v_unif =(hepscov2_unif->GetBinContent(i));
    hc_unif->SetBinContent(ima_unif-i+1,v_unif);
}


Float_t title_offset=1.1;
Float_t label_offset=0.01;
Float_t title_size=0.05;
Float_t label_size=0.05;

hc_unif->SetLineColor(kBlue);
hc_unif->SetLineStyle(9);
hc_unif->SetLineWidth(2);
hc_unif->SetTitle("Symmetric cumulants");
hc_unif->GetXaxis()->SetTitle("centrality");
hc_unif->GetYaxis()->SetTitle("SC(#epsilon_{2},#epsilon_{3})/(<#epsilon_{2}^{2}><#epsilon_{3}^{2}>)");
hc_unif->SetStats(kFALSE);
hc_unif->GetXaxis()->SetTitleOffset(title_offset);
hc_unif->GetXaxis()->SetLabelOffset(label_offset);
hc_unif->GetXaxis()->SetTitleSize(title_size);
hc_unif->GetXaxis()->SetLabelSize(label_size);
hc_unif->GetYaxis()->SetTitleOffset(title_offset);
hc_unif->GetYaxis()->SetLabelOffset(label_offset);
hc_unif->GetYaxis()->SetTitleSize(title_size);
hc_unif->GetYaxis()->SetLabelSize(label_size);
hc_unif->Rebin(reb);
hc_unif->Scale(1./reb);
hc_unif->GetXaxis()->SetRangeUser(0,.7);
hc_unif->GetYaxis()->SetRangeUser(-.2,.1);
hc_unif->Draw("HIST][");

canvas->Modified();
canvas->cd();
   
TTree *events_clust = (TTree*)f_clust->Get("events");
// nwAB is actually RDS (npa)
events_clust->SetBranchAddress("npa",&nwAB);
events_clust->SetBranchAddress("eps",&eps);
events_clust->SetBranchAddress("ep3s",&eps3);

Int_t nentries_clust = (Int_t)events_clust->GetEntries();
TH1D * huni_clust     = new TH1D("huni_clust",     "huni_clust",     hmaxreb, 0.5, hmax+.5);
TH1D * hepsn_clust    = new TH1D("hepsn_clust",    "hepsn_clust",    hmaxreb, 0.5, hmax+.5);
TH1D * hepsnt_clust   = new TH1D("hepsnt_clust",   "hepsnt_clust",   hmaxreb, 0.5, hmax+.5);
TH1D * hepsn2_clust   = new TH1D("hepsn2_clust",   "hepsn2_clust",   hmaxreb, 0.5, hmax+.5);
TH1D * hepsnt2_clust  = new TH1D("hepsnt2_clust",  "hepsnt2_clust",  hmaxreb, 0.5, hmax+.5);
TH1D * hepsn4_clust   = new TH1D("hepsn4_clust",   "hepsn4_clust",   hmaxreb, 0.5, hmax+.5);
TH1D * hepsnt4_clust  = new TH1D("hepsnt4_clust",  "hepsnt4_clust",  hmaxreb, 0.5, hmax+.5);
TH1D * hepscor_clust  = new TH1D("hepscor_clust",  "hepscor_clust",  hmaxreb, 0.5, hmax+.5);
TH1D * hepssc_clust   = new TH1D("hepssc_clust",   "hepssc_clust",   hmaxreb, 0.5, hmax+.5);
TH1D * hepscov2_clust = new TH1D("hepscov2_clust", "hepscov2_clust", hmaxreb, 0.5, hmax+.5);

for (Int_t i=0;i<nentries_clust;i++){
    events_clust->GetEntry(i);
    huni_clust -> Fill(nwAB,1);
    hepsn_clust -> Fill(nwAB,eps);
    hepsnt_clust -> Fill(nwAB,eps3);
    hepsn2_clust -> Fill(nwAB,eps*eps);
    hepsnt2_clust -> Fill(nwAB,eps3*eps3);
    hepsn4_clust -> Fill(nwAB,eps*eps*eps*eps);
    hepsnt4_clust -> Fill(nwAB,eps3*eps3*eps3*eps3);
    hepscor_clust -> Fill(nwAB,eps*eps3);
    hepssc_clust -> Fill(nwAB,eps*eps*eps3*eps3);
}

hepsn_clust->Divide(huni_clust);
hepsnt_clust->Divide(huni_clust);
hepsn2_clust->Divide(huni_clust);
hepsnt2_clust->Divide(huni_clust);
hepsn4_clust->Divide(huni_clust);
hepsnt4_clust->Divide(huni_clust);
hepscor_clust->Divide(huni_clust);
hepssc_clust->Divide(huni_clust);

for (Int_t i=1;i<=hmaxreb;i++) {
    Float_t vp_clust =(hepsn_clust->GetBinContent(i));
    Float_t vp2_clust =(hepsn2_clust->GetBinContent(i));
    Float_t vp4_clust =(hepsn4_clust->GetBinContent(i));
    Float_t vpt_clust =(hepsnt_clust->GetBinContent(i));
    Float_t vpt2_clust =(hepsnt2_clust->GetBinContent(i));
    Float_t vpt4_clust =(hepsnt4_clust->GetBinContent(i));
    Float_t vcor_clust =(hepscor_clust->GetBinContent(i));
    Float_t vcor2_clust =(hepssc_clust->GetBinContent(i));

    if(vp2_clust>0 && vpt2_clust>0){
    hepscov2_clust->SetBinContent(i,(vcor2_clust-vp2_clust*vpt2_clust)/(vp2_clust*vpt2_clust));        
    };
}


/****************************************/

TAxis *xaxis_clust = hepscov2_clust->GetXaxis();
Int_t ima_clust=(xaxis_clust->GetNbins());
Float_t ima_w_clust=(xaxis_clust->GetBinWidth(1));
Float_t zas_clust=ima_w_clust*ima_clust;
Float_t sc_clust=(huni_clust->Integral());

Int_t  binnum_clust = ima_clust; 
Float_t bins_clust[1800];
bins_clust[0]=0;

//! determination of centrality bins
for (Int_t i=1;i<=ima_clust;i++) {
    bins_clust[i]=bins_clust[i-1]+(huni_clust->GetBinContent(ima_clust-i+1))/sc_clust;    
};

TH1D* hc_clust = new TH1D("n_clust","hc_clust", binnum_clust, bins_clust);

for (Int_t i=1;i<=ima_clust;i++) {
    Float_t v_clust =(hepscov2_clust->GetBinContent(i));
    hc_clust->SetBinContent(ima_clust-i+1,v_clust);
}

hc_clust->SetLineColor(kRed);
hc_clust->SetLineWidth(2);
hc_clust->SetTitle("");
hc_clust->GetXaxis()->SetTitle("centrality");
hc_clust->GetXaxis()->CenterTitle(true);
hc_clust->GetXaxis()->SetLabelFont(42);
hc_clust->GetXaxis()->SetLabelSize(0.053);
hc_clust->GetXaxis()->SetTitleSize(0.07);
hc_clust->GetXaxis()->SetTitleOffset(.95);
hc_clust->GetXaxis()->SetTitleFont(42);
hc_clust->GetYaxis()->SetTitle("symmetric cumulant");
hc_clust->GetYaxis()->CenterTitle(true);
hc_clust->GetYaxis()->SetLabelFont(42);
hc_clust->GetYaxis()->SetLabelSize(0.053);
hc_clust->GetYaxis()->SetTitleSize(0.07);
hc_clust->GetYaxis()->SetTitleOffset(.95);
hc_clust->GetYaxis()->SetTitleFont(42);
hc_clust->GetYaxis()->SetRangeUser(-.25,0);
hc_clust->Rebin(reb);
hc_clust->Scale(1./reb);
hc_clust->Draw("HISTsame");

canvas->Modified();
canvas->cd();


TLegend *leg4 = new TLegend(0.7,0.65,0.95,0.78);
leg4->SetBorderSize(0);
leg4->SetFillColor(0);
leg4->AddEntry(hc_clust, "clusters", "l");
leg4->AddEntry(hc_unif, "uniform", "l");
leg4->Draw("SAME");

TLine *liml4 = new TLine(0.,0,1,0);
liml4->Draw("SAME");

char tEVENTS[60], tEVENTS2[60];

sprintf(tEVENTS,"%d+%d @ %.0f GeV",NUMA,NUMB,ECM_unif);
sprintf(tEVENTS2,"GLISSANDO 3");

Float_t x1=0.65, x2=0.18;
Float_t off=0.82;

TLatex *t1 = new TLatex();
t1->SetNDC();
t1->SetTextAlign(13);
t1->SetTextFont(32);
t1->SetTextColor(kBlack);
t1->SetTextSizePixels(18);
t1->SetTextAlign(12);
t1->DrawLatex(x1,off,tEVENTS);  
t1->DrawLatex(x2,off,tEVENTS2);


canvas->Modified();
canvas->cd();
canvas->SetSelected(canvas);

canvas->SaveAs("sc_comp.pdf");

}
