void part_dist_pp(
            char const *p //!< name of the ROOT input file
                ){
gROOT->Reset();
gStyle->SetPalette(1);

    gStyle->SetHistLineWidth(3);

TString empty("");

// Default file name
//TString inpfile("glissando.root");
char const *inpfile = "glissando.root";
 if (p!=empty) inpfile = p;
 cout << "reads from: " << inpfile << endl;

 
TFile *f = new TFile(inpfile);
TTree *itree = (TTree*)f->Get("events");
TTree *param = (TTree*)f->Get("param"); 

Float_t nwA, nwB, nwAB;
Float_t ECM;
Int_t PARTONS,NUMA,NUMB; 
Int_t max=10;

itree->SetBranchAddress("nwA",&nwA);
itree->SetBranchAddress("nwB",&nwB);
itree->SetBranchAddress("nwAB",&nwAB);
param->SetBranchAddress("PARTONS",&PARTONS);param->GetEntry(0);
param->SetBranchAddress("ECM",&ECM);param->GetEntry(0);
param->SetBranchAddress("NUMA",&NUMA);param->GetEntry(0);
param->SetBranchAddress("NUMB",&NUMB);param->GetEntry(0);

if (!PARTONS) {
	cout << "Macro designed for PARTON MODEL " << endl; 
    exit(0);
}

if (!((NUMA==1)&&(NUMB==1))) {
	cout << "Macro designed for nucleon+nucleon interactions only " << endl; 
    exit(0);
}

cout << NUMA << " + " <<NUMB << ", center-of-mass-energy, sqrt(s_NN): " << ECM << " GeV" << endl; 

TH1D *hist_nwA  = new TH1D("hist_nwA", "parton distribution in nucleon A",max+1,-0.5,max+0.5);
TH1D *hist_nwB  = new TH1D("hist_nwB", "parton distribution in nucleon B",max+1,-0.5,max+0.5);
TH1D *hist_nwAB = new TH1D("hist_nwAB","Number of wounded quarks",        max+1,-0.5,max+0.5);

Int_t nentries = (Int_t)itree->GetEntries();

for (Int_t i=1; i<=nentries; i++) {
    itree->GetEntry(i);
    hist_nwA->Fill(nwA,1);
    hist_nwB->Fill(nwB,1);
    hist_nwAB->Fill(nwAB,1);
}

Double_t scale = 1.0/hist_nwAB->Integral();
hist_nwAB->Scale(scale);
hist_nwAB->GetXaxis()->SetRange(1,8);


char tEVENTS[60];
sprintf(tEVENTS,"GLISSANDO 3    %d+%d @ %.0f GeV",NUMA,NUMB,ECM);

char tOPIS[60];
sprintf(tOPIS,"wounded quark model");

Float_t x1=0.45;
Float_t x2=0.58;
Float_t off1=0.85;
Float_t off2=0.78;

TLatex *t1 = new TLatex();
t1->SetNDC();
t1->SetTextAlign(13);
t1->SetTextFont(32);
t1->SetTextColor(kBlack);
t1->SetTextSizePixels(75);
t1->SetTextAlign(12);

TCanvas *c1= new TCanvas("c1", " inelasticity profile",0,0,1000,600);
c1->Range(0,0,25,18);
c1->SetFillColor(0);
gPad->SetFillStyle(4000);
gPad->SetFillColor(0);

Float_t title_offset=0.85;
Float_t label_offset=0.01;
Float_t title_size=0.05;
Float_t label_size=0.05;

gStyle->SetOptStat(kFALSE);

hist_nwAB->GetXaxis()->SetLabelOffset(label_offset);
hist_nwAB->GetXaxis()->SetLabelSize(label_size);
hist_nwAB->GetXaxis()->SetTitleSize(title_size);
hist_nwAB->GetXaxis()->SetTitleOffset(title_offset);
hist_nwAB->GetXaxis()->SetTitle("Q_{w}");
hist_nwAB->GetYaxis()->SetLabelOffset(label_offset);
hist_nwAB->GetYaxis()->SetLabelSize(label_size);
hist_nwAB->GetYaxis()->SetTitleSize(title_size);
hist_nwAB->GetYaxis()->SetTitleOffset(title_offset);
hist_nwAB->GetYaxis()->SetTitle("P(Q_{w})");
hist_nwAB->Draw("HIST");

t1->DrawLatex(x1,off1,tEVENTS);
t1->DrawLatex(x2,off2,tOPIS);
c1->Modified();
c1->SetSelected(c1);
c1->Update();

c1->SaveAs("part_dist_pp.pdf");

TFile *hfile = new TFile("part_dist_pp.root","RECREATE");
hfile->cd();
hist_nwA->Write();
hist_nwB->Write();
hist_nwAB->Write();

hfile->Close();  

}
