/** \file fourier.C
 * Script generating the epsilon_n vs. Q_w plot
 * (part of GLISSANDO 3)
 */

#include "label.C"

//! generates the plot of epsilon_n vs. Qw, n=2,3
/* Useful for flow analysis in NN collisions*/
void mult_Q(
    char const *p //!< name of the ROOT input file
){

gROOT->Reset();
gStyle->SetPalette(1);

TString empty("");

// Default file name
//TString inpfile("glissando.root");
char const *inpfile = "glissando.root";

 if (p!=empty) inpfile = p;
 cout << "reads from: " << inpfile << endl;;  

TFile *f     = new TFile(inpfile);
TTree *itree = (TTree*)f->Get("events");

int up=125;
label(inpfile);
TCanvas *c0 = new TCanvas("c0", "c2",49,120,648,439);
TH1D *h0 = new TH1D("h0","npa",up,0.5,up+0.5);
itree -> Draw("npa >> h0");

Double_t norm = h0->GetEntries();
h0->Scale(1/norm);


TCanvas *c2 = new TCanvas("c2","multiplicity",0,0,1000,600);
c2->cd(1);
c2->Range(0,0,25,18);
c2->SetFillColor(0);
c2->SetLogy();

Float_t title_offset=0.88;
Float_t label_offset=0.01;
Float_t title_size=0.05;
Float_t label_size=0.05;

label(inpfile);

h0->SetLineColor(kRed);
h0->SetStats(kFALSE);
h0->GetXaxis()->SetTitleOffset(title_offset);
h0->GetXaxis()->SetLabelOffset(label_offset);
h0->GetXaxis()->SetTitleSize(title_size);
h0->GetXaxis()->SetLabelSize(label_size);
h0->GetYaxis()->SetTitleOffset(title_offset);
h0->GetYaxis()->SetLabelOffset(label_offset);
h0->GetYaxis()->SetTitleSize(title_size);
h0->GetYaxis()->SetLabelSize(label_size);

h0->SetTitle("N_{ch} distribution");
h0->SetXTitle("N_{ch}       ");
h0->SetYTitle("P(N_{ch})  ");

h0->Draw("hist");

Int_t NUMA, NUMB;
Int_t PARTONS;
Float_t ECM_qq,ECM_NN,ALPHA;

TTree *param_NN = (TTree*)f->Get("param");
param_NN->SetBranchAddress("PARTONS",&PARTONS);param_NN->GetEntry(0);
param_NN->SetBranchAddress("NUMA",&NUMA);param_NN->GetEntry(0);
param_NN->SetBranchAddress("NUMB",&NUMB);param_NN->GetEntry(0);
param_NN->SetBranchAddress("ALPHA",&ALPHA);param_NN->GetEntry(0);
param_NN->SetBranchAddress("ECM",&ECM_NN);param_NN->GetEntry(0);

cout << "NN, center-of-mass-energy, sqrt(s_NN): " << ECM_NN << " GeV" << endl;

char tEVENTS[60];
sprintf(tEVENTS,"GLISSANDO 3   %d+%d @ %.0f GeV",NUMA,NUMB,ECM_NN);

char tOPIS[60];
if (ALPHA!=0.0)
    sprintf(tOPIS,"mixed model with ALPHA=%.3f",ALPHA);
else if (PARTONS==0) 
      sprintf(tOPIS,"wounded nucleon model");
  else 
      sprintf(tOPIS,"wounded quark model");

Float_t x1=0.47, x2=0.60;
Float_t off1=0.85, off2=0.78;

TLatex *t1 = new TLatex();
t1->SetNDC();
t1->SetTextAlign(13);
t1->SetTextFont(32);
t1->SetTextColor(kBlack);
t1->SetTextSizePixels(18);
t1->SetTextAlign(12);
t1->DrawLatex(x1,off1,tEVENTS);
t1->DrawLatex(x2,off2,tOPIS);
c2->Modified();
c2->cd();
c2->SetSelected(c0);

c2->SaveAs("multi_Q.pdf");

}
