#include "TCanvas.h"
#include "TStyle.h"
#include "TH1.h"


void clusters(
    char const *p //!< name of the ROOT input file
) {

TCanvas *c1 = new TCanvas("c1","alpha clusters in nucleus",300,1050);
gStyle->SetOptStat(kFALSE);

c1->Divide(1, 3, 0.03, 0.03);
c1->cd();
	
TString empty("");

// Default file name
//TString inpfile("glissando.root");
char const *inpfile = "glissando.root";
 if (p!=empty) inpfile = p;
 cout << "reads from: " << inpfile << endl;;  


TFile *f = new TFile(inpfile);
TTree *param = (TTree*)f->Get("param");

Float_t ECM;
Int_t NUMA,NUMB,CLUSTERS;
Int_t max=100;

param->SetBranchAddress("CLUSTERS",&CLUSTERS);param->GetEntry(0);
param->SetBranchAddress("ECM",&ECM);param->GetEntry(0);
param->SetBranchAddress("NUMA",&NUMA);param->GetEntry(0);
param->SetBranchAddress("NUMB",&NUMB);param->GetEntry(0);

if(!CLUSTERS) {cout << "Macro designed for cluster mode only " << endl; exit(0);}

cout << NUMA << " + " <<NUMB << ", center-of-mass-energy, sqrt(s_NN): " << ECM << " GeV" << endl;
cout << endl;

TH2D *hpxy = (TH2D*)f->Get("radA2xy"); 
TH2D *hpxz = (TH2D*)f->Get("radA2xz"); 
TH2D *hpyz = (TH2D*)f->Get("radA2yz"); 

char tEVENTS[60], tEVENTS2[60];

if ((NUMA==7)||(NUMA==9)) sprintf(tEVENTS," {}^{%d}Be",NUMA);
if (NUMA==12) sprintf(tEVENTS," {}^{%d}C",NUMA);
if (NUMA==16) sprintf(tEVENTS," {}^{%d}O",NUMA);

    sprintf(tEVENTS2,"GLISSANDO 3");

Float_t x1=0.65, x2=0.15;
Float_t off=0.85;

Float_t title_offset=0.9;
Float_t label_offset=0.005;
Float_t title_size=0.05;
Float_t label_size=0.05;


TLatex *t1 = new TLatex();
t1->SetNDC();
t1->SetTextAlign(13);
t1->SetTextFont(32);
t1->SetTextColor(kBlack);
t1->SetTextSize(0.08);
t1->SetTextAlign(12);


TLatex *t2 = new TLatex();
t2->SetNDC();
t2->SetTextAlign(13);
t2->SetTextFont(32);
t2->SetTextColor(kBlack);
t2->SetTextSize(0.06);
t2->SetTextAlign(12);


c1->Modified();
c1->cd();
c1->SetSelected(c1);
c1->cd(1);

hpxy->SetTitle("Density in xy plane");
hpxy->SetStats(kFALSE);
hpxy->GetXaxis()->SetTitleOffset(title_offset);
hpxy->GetXaxis()->SetLabelOffset(label_offset);
hpxy->GetXaxis()->SetTitleSize(title_size);
hpxy->GetXaxis()->SetLabelSize(label_size);
hpxy->GetYaxis()->SetTitleOffset(title_offset);
hpxy->GetYaxis()->SetLabelOffset(label_offset);
hpxy->GetYaxis()->SetTitleSize(title_size);
hpxy->GetYaxis()->SetLabelSize(label_size);

hpxy->GetXaxis()->SetTitle("x [fm]");
hpxy->GetYaxis()->SetTitle("y [fm]");
hpxy->Draw("col");
t1->DrawLatex(x1,off,tEVENTS);
t2->DrawLatex(x2,off,tEVENTS2);

c1->cd(2);

hpxz->SetTitle("Density in xz plane");
hpxz->SetStats(kFALSE);
hpxz->GetXaxis()->SetTitleOffset(title_offset);
hpxz->GetXaxis()->SetLabelOffset(label_offset);
hpxz->GetXaxis()->SetTitleSize(title_size);
hpxz->GetXaxis()->SetLabelSize(label_size);
hpxz->GetYaxis()->SetTitleOffset(title_offset);
hpxz->GetYaxis()->SetLabelOffset(label_offset);
hpxz->GetYaxis()->SetTitleSize(title_size);
hpxz->GetYaxis()->SetLabelSize(label_size);

hpxz->GetXaxis()->SetTitle("x [fm]");

hpxz->GetYaxis()->SetTitle("z [fm]");
hpxz->Draw("col");
t1->DrawLatex(x1,off,tEVENTS);
t2->DrawLatex(x2,off,tEVENTS2);

c1->cd(3);

hpyz->SetTitle("Density in yz plane");
hpyz->GetXaxis()->SetTitleOffset(title_offset);
hpyz->GetXaxis()->SetLabelOffset(label_offset);
hpyz->GetXaxis()->SetTitleSize(title_size);
hpyz->GetXaxis()->SetLabelSize(label_size);
hpyz->GetYaxis()->SetTitleOffset(title_offset);
hpyz->GetYaxis()->SetLabelOffset(label_offset);
hpyz->GetYaxis()->SetTitleSize(title_size);
hpyz->GetYaxis()->SetLabelSize(label_size);

hpyz->GetXaxis()->SetTitle("y [fm]");
hpyz->GetYaxis()->SetTitle("z [fm]");
hpyz->Draw("col");
t1->DrawLatex(x1,off,tEVENTS);
t2->DrawLatex(x2,off,tEVENTS2);

c1->Modified();
c1->SetSelected(c1);
c1->Update();

c1->SaveAs("clusters.pdf");

TFile *hfile = new TFile("clusters.root","RECREATE");
hfile->cd();
hpxy->Write();
hpxz->Write();
hpyz->Write();

hfile->Close(); 

}
