/** \file cent.C
 * Script generating the centrality distribution of wounded objects (part of GLISSANDO 3)
 */

//#include "label.C"

//! generates the centrality distribution of wounded objects
/*! generates the centrality distribution of wounded objects (nucleons or quarks) */
void cent_comp(char* p_qq, char* p_NN);


void cent_comp(
    char const *p_qq, //!< name of the ROOT input file
    char const *p_NN) 
{

TString empty("");

// Default file name
//TString inpfile_qq("glissando.root");
char const *inpfile_qq = "glissando.root";
 if (p_qq!=empty) inpfile_qq = p_qq;
 cout << "reads from: " << inpfile_qq << endl;  

TString inpfile_NN("glissando.root");
if (p_NN!=empty) inpfile_NN = p_NN;
cout << "reads from: " << inpfile_NN << endl;  
 
TFile *f_qq = new TFile(inpfile_qq);
TFile *f_NN = new TFile(inpfile_NN);

TH1D *n_qq = (TH1D*)f_qq->Get("nuniRDS"); 

TAxis *xaxis_qq = n_qq->GetXaxis();
Int_t ima_qq=(xaxis_qq->GetNbins());
Float_t ima_w_qq=(xaxis_qq->GetBinWidth(1));

Float_t sc_qq=(n_qq->Integral());

Float_t bins_qq[4000];
Int_t  binnum_qq = ima_qq; 

bins_qq[0]=0;

Double_t xp_qq[4000], 
         yp_qq[4000], 
         errxp_qq[4000], 
         erryp_qq[4000];

for (Int_t i=1;i<=ima_qq;i++){
    bins_qq[i]=bins_qq[i-1]+(n_qq->GetBinContent(ima_qq-i+1))/sc_qq;
    
    xp_qq[i]=bins_qq[i];
    yp_qq[i]=ima_qq-i+1;
    errxp_qq[i]=0;
    erryp_qq[i]=0;
};


TCanvas *c1= new TCanvas("c1", " centrality (RDS)",0,0,1000,600);
c1->Range(0,0,25,18);
c1->SetFillColor(0);
c1->SetLogy();   
gPad->SetFillStyle(4000);
gPad->SetFillColor(0);


//Float_t title_offset=.8;
Double_t xp_NN[4000], 
         yp_NN[4000], 
         errxp_NN[4000], 
         erryp_NN[4000];

TH1D *n_NN = (TH1D*)f_NN->Get("nuniRDS"); 

TAxis *xaxis_NN = n_NN->GetXaxis();
Int_t ima_NN=(xaxis_NN->GetNbins());
Float_t ima_w_NN=(xaxis_NN->GetBinWidth(1));

Float_t sc_NN=(n_NN->Integral());

Float_t bins_NN[4000];
Int_t  binnum_NN = ima_NN; 

bins_NN[0]=0;

for (Int_t i=1;i<=ima_NN;i++) {
    bins_NN[i]=bins_NN[i-1]+(n_NN->GetBinContent(ima_NN-i+1))/sc_NN;

    xp_NN[i]=bins_NN[i];
    yp_NN[i]=ima_NN-i+1;
    errxp_NN[i]=0;
    erryp_NN[i]=0;
};

Float_t title_offset=0.84;
Float_t label_offset=0.01;
Float_t title_size=0.05;
Float_t label_size=0.05;


TGraph *inv_qq = new TGraphErrors(ima_qq, xp_qq, yp_qq, errxp_qq, erryp_qq);
inv_qq->SetLineColor(kRed);
inv_qq->SetLineStyle(9);
inv_qq->SetLineWidth(3);
inv_qq->Draw("AC");

inv_qq->SetTitle(" ");
inv_qq->GetXaxis()->SetTitleOffset(title_offset);
inv_qq->GetXaxis()->SetLabelOffset(label_offset);
inv_qq->GetXaxis()->SetTitleSize(title_size);
inv_qq->GetXaxis()->SetLabelSize(label_size);
inv_qq->GetYaxis()->SetTitleOffset(title_offset);
inv_qq->GetYaxis()->SetLabelOffset(label_offset);
inv_qq->GetYaxis()->SetTitleSize(title_size);
inv_qq->GetYaxis()->SetLabelSize(label_size);

inv_qq->GetXaxis()->SetTitle("centrality");
inv_qq->GetYaxis()->SetTitle("RDS");
inv_qq->SetMinimum(1);
inv_qq->SetMaximum(10000);


inv_qq->GetXaxis()->SetRangeUser(0.01,1.1);
inv_qq->Draw("AC");
c1->Update();


TGraph *inv_NN = new TGraphErrors(ima_NN, xp_NN, yp_NN, errxp_NN, erryp_NN);

inv_NN->SetLineColor(kBlue);
inv_NN->SetLineStyle(3);
inv_NN->SetLineWidth(3);
inv_NN->Draw("C");

Int_t NUMA, NUMB;
Float_t ECM_qq,ECM_NN,ALPHA;

TTree *param_NN = (TTree*)f_NN->Get("param");
TTree *param_qq = (TTree*)f_qq->Get("param");

param_NN->SetBranchAddress("NUMA",&NUMA);param_NN->GetEntry(0);
param_NN->SetBranchAddress("NUMB",&NUMB);param_NN->GetEntry(0);
param_NN->SetBranchAddress("ALPHA",&ALPHA);param_NN->GetEntry(0);

param_NN->SetBranchAddress("ECM",&ECM_NN);param_NN->GetEntry(0); 
param_qq->SetBranchAddress("ECM",&ECM_qq);param_qq->GetEntry(0); 

cout << "qq, center-of-mass-energy, sqrt(s_NN): " << ECM_qq << " GeV" << endl;
cout << "NN, center-of-mass-energy, sqrt(s_NN): " << ECM_NN << " GeV" << endl; 

char tEVENTS[60];
sprintf(tEVENTS,"GLISSANDO 3   %d+%d @ %.0f GeV",NUMA,NUMB,ECM_qq);


Double_t xl1=.55, yl1=0.67, xl2=xl1+.3, yl2=yl1+.125;
TLegend *leg = new TLegend(xl1,yl1,xl2,yl2);
leg->SetBorderSize(0);
leg->SetFillColor(0);
leg->AddEntry(inv_qq, "quarks", "l");
leg->AddEntry(inv_NN, "nucleons", "l");
leg->Draw("SAME");

Float_t x=0.45;
Float_t off1=0.85, off2=0.8;

TLatex *t1 = new TLatex();
t1->SetNDC();
t1->SetTextAlign(13);
t1->SetTextFont(32);
t1->SetTextColor(kBlack);
t1->SetTextSizePixels(18);
t1->SetTextAlign(12);
t1->DrawLatex(x,off1,tEVENTS);  
c1->Modified();
c1->cd();
c1->SetSelected(c1); 


c1->SaveAs("cent_comp.pdf");

}
