/** \file cent.C
 * Script generating the centrality distribution of wounded objects (part of GLISSANDO 3)
 */

#include "label.C"

//! generates the centrality distribution of wounded objects
/*! generates the centrality distribution of wounded objects (nucleons or quarks) */

void cent(
 char const *p //!< name of the ROOT input file
            ) {

//TString empty("");
 char const *empty = "";

// Default file name
//TString inpfile("glissando.root");
 char const *inpfile = "glissando.root";
 if (p!=empty) inpfile = p;
 cout << "reads from: " << inpfile << endl;;  

ofstream *out = new ofstream;
out->open("centrality.dat");

TFile *f = new TFile(inpfile);

TH1D *n = ((TH1D*)f->Get("nuniRDS")); 

TAxis *xaxis = n->GetXaxis();
Int_t ima=(xaxis->GetNbins());
Float_t ima_w=(xaxis->GetBinWidth(1));

Float_t sc=(n->Integral());

Float_t bins[4000];
Int_t  binnum = ima; 

bins[0]=0;

Double_t xp[4000], yp[4000], errxp[4000], erryp[4000];

*out << "RDS" << "  centrality" << endl << endl;

for (Int_t i=1;i<=ima;i++) {bins[i]=bins[i-1]+(n->GetBinContent(ima-i+1))/sc;
if(bins[i]>0){*out << ima-i+1 << "  " << bins[i] << endl;};
xp[i]=bins[i];
yp[i]=ima-i+1;
errxp[i]=0;
erryp[i]=0;
};

TGraph *inv = new TGraphErrors(ima, xp, yp, errxp, erryp);
inv->SetTitle("centrality distribution;centrality;RDS");

TCanvas *c1= new TCanvas("c1", " centrality (RDS)",0,0,1000,600);
   c1->Range(0,0,25,18);
   c1->SetFillColor(0);
   
gPad->SetFillStyle(4000);
gPad->SetFillColor(0);

Float_t title_offset=.8;
//label(inpfile);

inv->Draw();


Int_t NUMA, NUMB;
Int_t PARTONS;
Float_t ECM_qq,ECM_NN,ALPHA;

TTree *param_NN = (TTree*)f->Get("param");

param_NN->SetBranchAddress("PARTONS",&PARTONS);param_NN->GetEntry(0);
param_NN->SetBranchAddress("NUMA",&NUMA);param_NN->GetEntry(0);
param_NN->SetBranchAddress("NUMB",&NUMB);param_NN->GetEntry(0);
param_NN->SetBranchAddress("ALPHA",&ALPHA);param_NN->GetEntry(0);
param_NN->SetBranchAddress("ECM",&ECM_NN);param_NN->GetEntry(0);

cout << "NN, center-of-mass-energy, sqrt(s_NN): " << ECM_NN << " GeV" << endl;

Char_t tEVENTS[60];
sprintf(tEVENTS,"GLISSANDO 3  %d+%d @ %.0f GeV",NUMA,NUMB,ECM_NN);

char tOPIS[60];
if (ALPHA!=0.0)
sprintf(tOPIS,"mixed model with ALPHA=%.3f",ALPHA);
else
  if (PARTONS==0) sprintf(tOPIS,"wounded nucleon model");
  else sprintf(tOPIS,"wounded quark model");

Float_t x=0.40;
Float_t off1=0.85, off2=0.8;

TLatex *t1 = new TLatex();
t1->SetNDC();
t1->SetTextAlign(13);
   t1->SetTextFont(32);
   t1->SetTextColor(kBlack);
   t1->SetTextSizePixels(18);
   t1->SetTextAlign(12);
   t1->DrawLatex(x,off1,tEVENTS);
   t1->DrawLatex(x,off2,tOPIS);
   c1->Modified();
   c1->cd();
   c1->SetSelected(c1);

c1->SaveAs("cen.pdf");

}
