 /** \file centrality2.C
 * Script generating the centrality classes (alternative to centrality.C)
 * (part of GLISSANDO 2)
 * 
 */

#include "label.C"

// Produces centrality windows for the stored Root file.
// This makes sense for minimum bias calculations.
// Plot centrality versus number of wounded nucleons,
// weight, and impact parameter

//! generates the centrality classes
/*! Centrality classes are generated in the total number of wounded nucleons, relative deposited strenth (RDS), and the 
    impact parameter. Plots of distributions divided into classes are produced. The script makes sense for the minimum-bias simulations. */
void centrality2(
 char const *p //!< name of the ROOT input file
                ) {

gROOT->Reset();
gStyle->SetOptStat(0);

ofstream *out = new ofstream;
out->open("centrality2out.dat");

cout << endl << "Determination of the centrality classes" << endl;
cout <<  "(Warning: this script makes sense for minimum-bias events)" << endl << endl;
*out << endl << "Determination of the centrality classes" << endl;
*out <<  "(Warning: this script makes sense for minimum-bias events)" << endl << endl;

TString empty("");

// Default file name
//TString inpfile("glissando.root");
char const *inpfile = "glissando.root";

 if (p!=empty) inpfile = p;
 cout << "reads from: " << inpfile << ", writes to centrality2.dat" << endl;  
 *out << "reads from: " << inpfile << ", writes to centrality2.dat" << endl;  

cout << endl << "(number of bins in b and RDS determines the resolution)" << endl;

TFile *f = new TFile(inpfile);

TTree *events = (TTree*)f->Get("events");
Float_t b,nwAB,npa;
events->SetBranchAddress("b",&b);
events->SetBranchAddress("nwAB",&nwAB);
events->SetBranchAddress("npa",&npa);


Float_t max_b=b;
Float_t max_nw=nwAB;
Float_t max_npa=npa;
Float_t min_b=b;
Float_t min_nw=nwAB;
Float_t min_npa=npa;


Int_t nentries = (Int_t)events->GetEntries();
for (Int_t i=0;i<1;i++){
events->GetEntry(i);
}

for (Int_t i=1; i<nentries; i++) {
events->GetEntry(i);

if (b>max_b) max_b=b;
if (nwAB>max_nw) max_nw=nwAB;
if (npa>max_npa) max_npa=npa;
if (b<min_b) min_b=b;
if (nwAB<min_nw) min_nw=nwAB;
if (npa<min_npa) min_npa=npa;

}

cout <<"b min: "<<min_b<<", "<< "b max: " << max_b << endl;
cout <<"N_w min: "<<min_nw<<", "<<"N_w max: "<< max_nw << endl;
cout <<"RDS min: "<<min_npa<<", "<<"RDS max: "<< max_npa << endl;
cout << endl << endl;

*out <<"b min: "<<min_b<<", "<< "b max: " << max_b << endl;
*out <<"N_w min: "<<min_nw<<", "<<"N_w max: "<< max_nw << endl;
*out <<"RDS min: "<<min_npa<<", "<<"RDS max: "<< max_npa << endl;
*out << endl;


if (min_b==max_b){
min_b=min_b-0.01;
max_b=max_b+0.01;
}


const Int_t nbin_b=600;
const Int_t nbin_nw=(max_nw-min_nw);
const Int_t nbin_npa=600;
// const Int_t nbin_npa=(max_npa-min_npa);

const Float_t st_b=(max_b-min_b)/nbin_b;
const Float_t st_nw=(max_nw-min_nw)/nbin_nw;
const Float_t st_npa=(max_npa-min_npa)/nbin_npa;

TH1D* hist_b = new TH1D("hist_b","hist_b",nbin_b+1,min_b-st_b/2.,max_b+st_b/2.);
TH1D* hist_nw = new TH1D("hist_nw","hist_nw",nbin_nw+1,min_nw-st_nw/2.,max_nw+st_nw/2.);
TH1D* hist_npa = new TH1D("hist_npa","hist_npa",nbin_npa+1,min_npa-st_npa/2.,max_npa+st_npa/2.);

for (Int_t i=0; i<nentries; i++) {
events->GetEntry(i);
hist_b->Fill(b);
hist_nw->Fill(nwAB);
hist_npa->Fill(npa);
}

bool s5, s10, s20, s30, s40, s50, s60, s70, s80, s90;
Float_t tot;
TAxis *xaxis;
Int_t ima;
Float_t w, v, sum, run;
Int_t j;
TH1D *h, *h2, *h3;
 
Float_t x5,x10,x20,x30,x40,x50,x60,x70,x80,x90;
Float_t v5,v10,v20,v30,v40,v50,v60,v70,v80,v90;

Float_t xnw5,xnw10,xnw20,xnw30,xnw40,xnw50,xnw60,xnw70,xnw80,xnw90;
Float_t vnw5,vnw10,vnw20,vnw30,vnw40,vnw50,vnw60,vnw70,vnw80,vnw90;

Float_t xrds5,xrds10,xrds20,xrds30,xrds40,xrds50,xrds60,xrds70,xrds80,xrds90;
Float_t vrds5,vrds10,vrds20,vrds30,vrds40,vrds50,vrds60,vrds70,vrds80,vrds90;

Float_t maxpl,maxpl_nw,maxpl_rds;
// -------------------------------------------------

h=hist_b;

tot= h->Integral();

cout << "number of entries: " << tot << endl << endl;
*out << "number of entries: " << tot << endl << endl;

xaxis = h->GetXaxis();
ima=(xaxis->GetNbins());
w=(xaxis->GetBinWidth(1));
sum = 0;
s5=true, s10=true, s20=true, s30=true, s40=true, s50=true, s60=true, s70=true, s80=true, s90=true;

cout <<  "centrality --> range in b " << endl << endl;
*out <<  "centrality --> range in b " << endl << endl;

//for(Int_t i=ima;i>0;i--) {
for (Int_t i=1;i<ima;i++) {
v=(h->GetBinContent(i)); 
sum+=v; run=100.*sum/tot;
//cout << " v= "<<v<<"tot = "<<tot<<"  sum = "<<sum<<"  run= "<<run<<endl;
 

//if(v>0){cout << "debug:  " << run << "% ---> b=" << (i-1)*w+min_b << endl;}
if(run>5 && s5){cout <<   " 0- 5%  --> [" << min_b << "," << (i)*w+min_b << "]" << endl; *out <<   " 0- 5%  --> [" << min_b << "," << (i)*w+min_b << "]" << endl; s5=false;j=i-1;
 x5=(i-0.5)*w+min_b;
 v5=v;
};

if(run>10 && s10){cout << " 5-10%  --> [" << j*w+min_b << "," << (i)*w+min_b << "]" << endl; *out << " 5-10%  --> [" << j*w+min_b << "," << (i)*w+min_b << "]" << endl; s10=false;j=i-1;
 x10=(i-0.5)*w+min_b;
 v10=v;
};

if(run>20 && s20){cout << "10-20%  --> [" << j*w+min_b << "," << (i)*w+min_b << "]" << endl; *out << "10-20%  --> [" << j*w+min_b << "," << (i)*w+min_b << "]" << endl; s20=false;j=i-1;
 x20=(i-0.5)*w+min_b;
 v20=v;
};

if(run>30 && s30){cout << "20-30%  --> [" << j*w+min_b << "," << (i)*w+min_b << "]" << endl; *out << "20-30%  --> [" << j*w+min_b << "," << (i)*w+min_b << "]" << endl; s30=false;j=i-1;
 x30=(i-0.5)*w+min_b;
 v30=v;
};

if(run>40 && s40){cout << "30-40%  --> [" << j*w+min_b << "," << (i)*w+min_b << "]" << endl; *out << "30-40%  --> [" << j*w+min_b << "," << (i)*w+min_b << "]" << endl; s40=false;j=i-1;
 x40=(i-0.5)*w+min_b;
 v40=v;
};

if(run>50 && s50){cout << "40-50%  --> [" << j*w+min_b << "," << (i)*w+min_b << "]" << endl; *out << "40-50%  --> [" << j*w+min_b << "," << (i)*w+min_b << "]" << endl; s50=false;j=i-1;
 x50=(i-0.5)*w+min_b;
 v50=v;
};

if(run>60 && s60){cout << "50-60%  --> [" << j*w+min_b << "," << (i)*w+min_b << "]" << endl; *out << "50-60%  --> [" << j*w+min_b << "," << (i)*w+min_b << "]" << endl; s60=false;j=i-1; 
 maxpl=v;
 x60=(i-0.5)*w+min_b;
 v60=v;
};

if(run>70 && s70){cout << "60-70%  --> [" << j*w+min_b << "," << (i)*w+min_b << "]" << endl; *out << "60-70%  --> [" << j*w+min_b << "," << (i)*w+min_b << "]" << endl; s70=false;j=i-1;
 x70=(i-0.5)*w+min_b;
 v70=v;
};

if(run>80 && s80){cout << "70-80%  --> [" << j*w+min_b << "," << (i)*w+min_b << "]" << endl; *out << "70-80%  --> [" << j*w+min_b << "," << (i)*w+min_b << "]" << endl; s80=false;j=i-1;
 x80=(i-0.5)*w+min_b;
 v80=v;
};

if(run>90 && s90){cout << "80-90%  --> [" << j*w+min_b << "," << (i)*w+min_b << "]" << endl; *out << "80-90%  --> [" << j*w+min_b << "," << (i)*w+min_b << "]" << endl; s90=false;j=i-1;
 x90=(i-0.5)*w+min_b;
 v90=v;
                  cout << "90-100% --> [" << j*w+min_b << "," << max_b << "]" << endl; *out << "90-100% --> [" << j*w+min_b << "," << max_b << "]" << endl;};
};

TCanvas *cb = new TCanvas("cb","centrality classes in b",650,600);
cb->cd(1);
cb->Range(0,0,25,18);
cb->SetFillColor(0);

label(inpfile);

TPad *padb = new TPad("padb","c(b)",0.02,0.02,0.98,0.78,33);
padb->Draw();
padb->cd();
padb->SetFillStyle(4000);
padb->SetFillColor(0);

// h->GetYaxis()->SetRangeUser(0.,1.5*maxpl);

h->SetTitle("division into 0-5%, 5-10%, 10-20%, 20-30%, ..., 90-100% centrality classes");
h->SetXTitle("b [fm]   ");
h->SetLineColor(kCyan);

h->Draw("HIST");
 TLine *lim5 = new TLine(x5,0.,x5,v5);
 TLine *lim10 = new TLine(x10,0.,x10,v10);
 TLine *lim20 = new TLine(x20,0.,x20,v20);
 TLine *lim30 = new TLine(x30,0.,x30,v30);
 TLine *lim40 = new TLine(x40,0.,x40,v40);
 TLine *lim50 = new TLine(x50,0.,x50,v50);
 TLine *lim60 = new TLine(x60,0.,x60,v60);
 TLine *lim70 = new TLine(x70,0.,x70,v70);
 TLine *lim80 = new TLine(x80,0.,x80,v80);
 TLine *lim90 = new TLine(x90,0.,x90,v90);

lim5->Draw("SAME");lim10->Draw("SAME");lim20->Draw("SAME");lim30->Draw("SAME");lim40->Draw("SAME");
lim50->Draw("SAME");lim60->Draw("SAME");lim70->Draw("SAME");lim80->Draw("SAME");lim90->Draw("SAME");

cb->SaveAs("centrality_b.pdf");

// ---------

h=hist_nw;

tot= h->Integral();

cout << endl << endl << "number of entries: " << tot << endl << endl;
*out << endl << endl << "number of entries: " << tot << endl << endl;

xaxis = h->GetXaxis();
ima=(xaxis->GetNbins());
w=(xaxis->GetBinWidth(1));
sum = 0;
s5=true, s10=true, s20=true, s30=true, s40=true, s50=true, s60=true, s70=true, s80=true, s90=true;


cout <<  "centrality --> range in N_w " << endl << endl;
*out <<  "centrality --> range in N_w " << endl << endl;


for(Int_t i=ima;i>0;i--) {
v=(h->GetBinContent(i)); 
sum+=v; run=100.*sum/tot;
//if(v>0){cout << "debug:  " << run << "% ---> N_w=" << (i-1)*w+min_nw << endl;}
if(run>5 && s5){cout <<   " 0- 5%  --> [" << max_nw << "," << (i)*w+min_nw << "]" << endl; *out <<   " 0- 5%  --> [" << max_nw << "," << (i)*w+min_nw << "]" << endl; s5=false;j=i-1;
 xnw5=(i-0.5)*w+min_nw;
 vnw5=v;
};
if(run>10 && s10){cout << " 5-10%  --> [" << j*w+min_nw << "," << (i)*w+min_nw << "]" << endl; *out << " 5-10%  --> [" << j*w+min_nw << "," << (i)*w+min_nw << "]" << endl; s10=false;j=i-1;
 xnw10=(i-0.5)*w+min_nw;
 vnw10=v;
};
if(run>20 && s20){cout << "10-20%  --> [" << j*w+min_nw << "," << (i)*w+min_nw << "]" << endl; *out << "10-20%  --> [" << j*w+min_nw << "," << (i)*w+min_nw << "]" << endl; s20=false;j=i-1;
 xnw20=(i-0.5)*w+min_nw;
 vnw20=v;
};
if(run>30 && s30){cout << "20-30%  --> [" << j*w+min_nw << "," << (i)*w+min_nw << "]" << endl; *out << "20-30%  --> [" << j*w+min_nw << "," << (i)*w+min_nw << "]" << endl; s30=false;j=i-1;
 xnw30=(i-0.5)*w+min_nw;
 vnw30=v;
};
if(run>40 && s40){cout << "30-40%  --> [" << j*w+min_nw << "," << (i)*w+min_nw << "]" << endl; *out << "30-40%  --> [" << j*w+min_nw << "," << (i)*w+min_nw << "]" << endl; s40=false;j=i-1;
 xnw40=(i-0.5)*w+min_nw;
 vnw40=v;
};
if(run>50 && s50){cout << "40-50%  --> [" << j*w+min_nw << "," << (i)*w+min_nw << "]" << endl; *out << "40-50%  --> [" << j*w+min_nw << "," << (i)*w+min_nw << "]" << endl; s50=false;j=i-1;
 xnw50=(i-0.5)*w+min_nw;
 vnw50=v;
};
if(run>60 && s60){cout << "50-60%  --> [" << j*w+min_nw << "," << (i)*w+min_nw << "]" << endl; *out << "50-60%  --> [" << j*w+min_nw << "," << (i)*w+min_nw << "]" << endl; s60=false;j=i-1; 
 maxpl_nw=v;
 xnw60=(i-0.5)*w+min_nw;
 vnw60=v;
};
if(run>70 && s70){cout << "60-70%  --> [" << j*w+min_nw << "," << (i)*w+min_nw << "]" << endl; *out << "60-70%  --> [" << j*w+min_nw << "," << (i)*w+min_nw << "]" << endl; s70=false;j=i-1;
 xnw70=(i-0.5)*w+min_nw;
 vnw70=v;
};
if(run>80 && s80){cout << "70-80%  --> [" << j*w+min_nw << "," << (i)*w+min_nw << "]" << endl; *out << "70-80%  --> [" << j*w+min_nw << "," << (i)*w+min_nw << "]" << endl; s80=false;j=i-1;
 xnw80=(i-0.5)*w+min_nw;
 vnw80=v;
};
if(run>90 && s90){cout << "80-90%  --> [" << j*w+min_nw << "," << (i)*w+min_nw << "]" << endl; *out << "80-90%  --> [" << j*w+min_nw << "," << (i)*w+min_nw << "]" << endl; s90=false;j=i-1;
 xnw90=(i-0.5)*w+min_nw;
 vnw90=v;
                  cout << "90-100% --> [" << j*w+min_nw << "," << min_nw << "]" << endl; *out << "90-100% --> [" << j*w+min_nw << "," << min_nw << "]" << endl;};

};


TCanvas *cnw = new TCanvas("cnw","centrality classes in N_w",650,600);
cnw->cd(1);
cnw->Range(0,0,25,18);
cnw->SetFillColor(0);

label(inpfile);

TPad *padnw = new TPad("padnw","c(N_w)",0.02,0.02,0.98,0.78,33);
padnw->Draw();
padnw->cd();
padnw->SetFillStyle(4000);
padnw->SetFillColor(0);

h->GetYaxis()->SetRangeUser(0.,1.5*maxpl_nw);

h->SetTitle("division into 0-5%, 5-10%, 10-20%, 20-30%, ..., 90-100% centrality classes");
h->SetXTitle("N_{W}   ");
h->SetLineColor(kCyan);

h->Draw("HIST");


 TLine *lim5nw = new TLine(xnw5,0.,xnw5,vnw5);
 TLine *lim10nw = new TLine(xnw10,0.,xnw10,vnw10);
 TLine *lim20nw = new TLine(xnw20,0.,xnw20,vnw20);
 TLine *lim30nw = new TLine(xnw30,0.,xnw30,vnw30);
 TLine *lim40nw = new TLine(xnw40,0.,xnw40,vnw40);
 TLine *lim50nw = new TLine(xnw50,0.,xnw50,vnw50);
 TLine *lim60nw = new TLine(xnw60,0.,xnw60,vnw60);
 TLine *lim70nw = new TLine(xnw70,0.,xnw70,vnw70);
 TLine *lim80nw = new TLine(xnw80,0.,xnw80,vnw80);
 TLine *lim90nw = new TLine(xnw90,0.,xnw90,vnw90);


lim5nw->Draw("SAME");lim10nw->Draw("SAME");lim20nw->Draw("SAME");lim30nw->Draw("SAME");lim40nw->Draw("SAME");
lim50nw->Draw("SAME");lim60nw->Draw("SAME");lim70nw->Draw("SAME");lim80nw->Draw("SAME");lim90nw->Draw("SAME");

cnw->SaveAs("centrality_nw.pdf");

// -----------------------------------------------------------------

h=hist_npa;

tot= h->Integral();

cout << endl << endl << "number of entries: " << tot << endl << endl;
*out << endl << endl << "number of entries: " << tot << endl << endl;

xaxis = h->GetXaxis();
ima=(xaxis->GetNbins());
w=(xaxis->GetBinWidth(1));
sum = 0;
s5=true, s10=true, s20=true, s30=true, s40=true, s50=true, s60=true, s70=true, s80=true, s90=true;


cout <<  "centrality --> range in RDS " << endl << endl;
*out <<  "centrality --> range in RDS " << endl << endl;


for(Int_t i=ima;i>0;i--) {
//for (Int_t i=1;i<ima;i++) {
v=(h->GetBinContent(i)); 
sum+=v; run=100.*sum/tot;
//if(v>0){cout << "debug:  " << run << "% ---> RDS=" << (i-1)*w+min_npa << endl;}
if(run>5 && s5){cout <<   " 0- 5%  --> [" << max_npa << "," << (i)*w+min_npa << "]" << endl; *out <<   " 0- 5%  --> [" << max_npa << "," << (i)*w+min_npa << "]" << endl; s5=false;j=i-1;
 xrds5=(i-0.5)*w+min_npa;
 vrds5=v;
};
if(run>10 && s10){cout << " 5-10%  --> [" << j*w+min_npa << "," << (i)*w+min_npa << "]" << endl; *out << " 5-10%  --> [" << j*w+min_npa << "," << (i)*w+min_npa << "]" << endl; s10=false;j=i-1;
 xrds10=(i-0.5)*w+min_npa;
 vrds10=v;

};
if(run>20 && s20){cout << "10-20%  --> [" << j*w+min_npa << "," << (i)*w+min_npa << "]" << endl; *out << "10-20%  --> [" << j*w+min_npa << "," << (i)*w+min_npa << "]" << endl; s20=false;j=i-1;
 xrds20=(i-0.5)*w+min_npa;
 vrds20=v;
};
if(run>30 && s30){cout << "20-30%  --> [" << j*w+min_npa << "," << (i)*w+min_npa << "]" << endl; *out << "20-30%  --> [" << j*w+min_npa << "," << (i)*w+min_npa << "]" << endl; s30=false;j=i-1;
 xrds30=(i-0.5)*w+min_npa;
 vrds30=v;
};
if(run>40 && s40){cout << "30-40%  --> [" << j*w+min_npa << "," << (i)*w+min_npa << "]" << endl; *out << "30-40%  --> [" << j*w+min_npa << "," << (i)*w+min_npa << "]" << endl; s40=false;j=i-1;
 xrds40=(i-0.5)*w+min_npa;
 vrds40=v;
};
if(run>50 && s50){cout << "40-50%  --> [" << j*w+min_npa << "," << (i)*w+min_npa << "]" << endl; *out << "40-50%  --> [" << j*w+min_npa << "," << (i)*w+min_npa << "]" << endl; s50=false;j=i-1;
 xrds50=(i-0.5)*w+min_npa;
 vrds50=v;
};
if(run>60 && s60){cout << "50-60%  --> [" << j*w+min_npa << "," << (i)*w+min_npa << "]" << endl; *out << "50-60%  --> [" << j*w+min_npa << "," << (i)*w+min_npa << "]" << endl; s60=false;j=i-1; 
 maxpl_rds=v;
 xrds60=(i-0.5)*w+min_npa;
 vrds60=v;
};
if(run>70 && s70){cout << "60-70%  --> [" << j*w+min_npa << "," << (i)*w+min_npa << "]" << endl; *out << "60-70%  --> [" << j*w+min_npa << "," << (i)*w+min_npa << "]" << endl; s70=false;j=i-1;
 xrds70=(i-0.5)*w+min_npa;
 vrds70=v;
};
if(run>80 && s80){cout << "70-80%  --> [" << j*w+min_npa << "," << (i)*w+min_npa << "]" << endl; *out << "70-80%  --> [" << j*w+min_npa << "," << (i)*w+min_npa << "]" << endl; s80=false;j=i-1;
 xrds80=(i-0.5)*w+min_npa;
 vrds80=v;
};
if(run>90 && s90){cout << "80-90%  --> [" << j*w+min_npa << "," << (i)*w+min_npa << "]" << endl; *out << "80-90%  --> [" << j*w+min_npa << "," << (i)*w+min_npa << "]" << endl; s90=false;j=i-1;
 xrds90=(i-0.5)*w+min_npa;
 vrds90=v;
                  cout << "90-100% --> [" << j*w+min_npa << "," << min_npa << "]" << endl; *out << "90-100% --> [" << j*w+min_npa << "," << min_npa << "]" << endl;};
};

TCanvas *cnpa = new TCanvas("cnpa","centrality classes in RDS",650,600);
cnpa->cd(1);
cnpa->Range(0,0,25,18);
cnpa->SetFillColor(0);

label(inpfile);

TPad *padnpa = new TPad("padnpa","c(RDS)",0.02,0.02,0.98,0.78,33);
padnpa->Draw();
padnpa->cd();
padnpa->SetFillStyle(4000);
padnpa->SetFillColor(0);

h->GetYaxis()->SetRangeUser(0.,1.*maxpl_rds);

h->SetTitle("division into 0-5%, 5-10%, 10-20%, 20-30%, ..., 90-100% centrality classes");
h->SetXTitle("RDS   ");
h->SetLineColor(kCyan);

h->Draw("HIST");

 TLine *lim5rds = new TLine(xrds5,0.,xrds5,vrds5);
 TLine *lim10rds = new TLine(xrds10,0.,xrds10,vrds10);
 TLine *lim20rds = new TLine(xrds20,0.,xrds20,vrds20);
 TLine *lim30rds = new TLine(xrds30,0.,xrds30,vrds30);
 TLine *lim40rds = new TLine(xrds40,0.,xrds40,vrds40);
 TLine *lim50rds = new TLine(xrds50,0.,xrds50,vrds50);
 TLine *lim60rds = new TLine(xrds60,0.,xrds60,vrds60);
 TLine *lim70rds = new TLine(xrds70,0.,xrds70,vrds70);
 TLine *lim80rds = new TLine(xrds80,0.,xrds80,vrds80);
 TLine *lim90rds = new TLine(xrds90,0.,xrds90,vrds90);

lim5rds->Draw("SAME");lim10rds->Draw("SAME");lim20rds->Draw("SAME");lim30rds->Draw("SAME");lim40rds->Draw("SAME");
lim50rds->Draw("SAME");lim60rds->Draw("SAME");lim70rds->Draw("SAME");lim80rds->Draw("SAME");lim90rds->Draw("SAME");

cnpa->SaveAs("centrality_RDS.pdf");

}

