#!/bin/bash

if [[ "$OSTYPE" == "linux-gnu"* ]]; then
        echo "linux"
        VIEW=evince
        
elif [[ "$OSTYPE" == "darwin"* ]]; then
        echo "Mac OSX, ROOT ver. 6.20.04 (Catalina)"
        export DYLD_LIBRARY_PATH=/Applications/root_v6.20.04/lib
        VIEW=open
fi

# init
function pause(){
   read -p "$*"
}
 

echo "Demo of down-compatibility with GLISSANDO 2"
pause "Press ENTER to start"


: <<'END'

echo "This block is commented out"
echo "you can move the line below to any locaton to comment out the commands in between"

END

# complile with standard precompiler options

make clean
make 'PREPROCESS =  -D_nnwp_=2 -D_bindep_=1 -D_files_=0 -D_profile_=0 -D_weight_=0 -D_evout_=0 -D_clusters_=0 -D_uncluster_=0 -D_partons_=0 -D_pardis_=0 -D_rdsconv_=1'

# running
QUESTION="Do you want to start this part of the script (yes/no) ?"

pause "Press ENTER to see the help"
./glissando3 -h

pause "Press ENTER to see the version"
./glissando3 -v

if [ ! -d "./output/demo_2" ]
then
    mkdir output/demo_2
fi

echo ""
echo "The fastest example: a single event in the hot-spot model, Pb+Pb @ LHC"
echo "$QUESTION"

read ANSWER

if [[ "$ANSWER" == "yes" || "$ANSWER" == "YES" || "$ANSWER" == "y" || "$ANSWER" == "Y" ]]; then
./glissando3 input/demo_2/input_snap.dat output/demo_2/glissando.root 2> err

cd output/demo_2
root -b -l -q -x "../../macro/demo_2/density.C(\"glissando.root\")"
cp 3D-density.pdf 3D-density_snap.pdf
cp 2D-density.pdf 2D-density_snap.pdf
$VIEW 3D-density.pdf 2> err &
$VIEW 2D-density.pdf 2> err &
cd ../..

else
echo "Part of the script to run the fastest example: a single event in the hot-spot model, Pb+Pb @ LHC  is NOT EXECUTED"
fi
echo ""

echo "The central deuteron-Au collisions"
echo "$QUESTION"

read ANSWER

if [[ "$ANSWER" == "yes" || "$ANSWER" == "YES" || "$ANSWER" == "y" || "$ANSWER" == "Y" ]]; then
./glissando3 input/demo_2/input_d_Au.dat output/demo_2/dAu.root 2> err

cd output/demo_2
cp 2D-density.pdf 2D-density_dAu.pdf
root -b -l -q -x "../../macro/demo_2/info.C(\"dAu.root\")" 
root -b -l -q -x "../../macro/demo_2/density.C(\"dAu.root\")" 
$VIEW 2D-density_dAu.pdf 2> err &
cd ../..

else
echo "Part of the script to run central deuteron-Au collisions is NOT EXECUTED"
fi
echo ""

echo "The minimum-bias Pb-Pb run for LHC"
echo "$QUESTION"

read ANSWER

if [[ "$ANSWER" == "yes" || "$ANSWER" == "YES" || "$ANSWER" == "y" || "$ANSWER" == "Y" ]]; then
make clean
make 'PREPROCESS =  -D_nnwp_=2 -D_bindep_=1 -D_files_=0 -D_profile_=0 -D_weight_=0 -D_evout_=0 -D_clusters_=0 -D_uncluster_=0 -D_partons_=0 -D_pardis_=0 -D_rdsconv_=1'

./glissando3 input/demo_2/input_minbias_LHC.dat output/demo_2/lhc.root 2> err

cd output/demo_2
root -b -l -q -x "../../macro/demo_2/centrality2.C(\"lhc.root\")"
$VIEW centrality_b.pdf 2> err &
$VIEW centrality_nw.pdf 2> err &
$VIEW centrality_RDS.pdf 2> err &
root -b -l -q -x "../../macro/demo_2/epsilon.C(\"lhc.root\")" 
cp epsilon.pdf eps_lhc.pdf
$VIEW eps_lhc.pdf 2> err &
$VIEW sigma_epsilon.pdf 2> err &
root -b -l -q -x "../../macro/demo_2/fourier.C(\"lhc.root\")" 
$VIEW epsn.pdf 2> err &
root -b -l -q -x "../../macro/demo_2/size.C(\"lhc.root\")" 
$VIEW sigma_r.pdf 2> err &
root -b -l -q -x "../../macro/demo_2/mult.C(\"lhc.root\")" 
$VIEW om_RDS.pdf 2> err &
cd ../..

else
echo "Part of the script to run the minimum-bias Pb-Pb run for LHC is NOT EXECUTED"
fi
echo ""

echo "The asymmetric collisions"
echo "$QUESTION"

read ANSWER

if [[ "$ANSWER" == "yes" || "$ANSWER" == "YES" || "$ANSWER" == "y" || "$ANSWER" == "Y" ]]; then
./glissando3 input/demo_2/input_S_Pb_SPS.dat output/demo_2/SPb.root 2> err
cd output/demo_2
root -b -l -q -x "../../macro/demo_2/epsilon.C(\"SPb.root\")" 
$VIEW epsilon.pdf 2> err &
cd ../..

else
echo "Part of the script to run asymmetric collisions is NOT EXECUTED"
fi
echo ""

echo "The deformed and spherical U+U, Au+Au and Cu+Cu collisions"
echo "$QUESTION"

read ANSWER

if [[ "$ANSWER" == "yes" || "$ANSWER" == "YES" || "$ANSWER" == "y" || "$ANSWER" == "Y" ]]; then
make clean
make 'PREPROCESS =  -D_nnwp_=2 -D_bindep_=1 -D_files_=0 -D_profile_=1 -D_weight_=0 -D_evout_=0 -D_clusters_=0 -D_uncluster_=0 -D_partons_=0 -D_pardis_=0 -D_rdsconv_=1'

./glissando3 input/demo_2/input_minbias_UU_mixed_deformed_norot.dat output/demo_2/output_minbias_UU_mixed_deformed_norot.root 2> err
./glissando3 input/demo_2/input_minbias_UU_mixed_spherical_norot.dat output/demo_2/output_minbias_UU_mixed_spherical_norot.root 2> err
./glissando3 input/demo_2/input_minbias_Cu63Cu63_mixed_deformed_norot.dat output/demo_2/output_minbias_Cu63Cu63_mixed_deformed_norot.root 2> err
./glissando3 input/demo_2/input_minbias_Cu63Cu63_mixed_spherical_norot.dat output/demo_2/output_minbias_Cu63Cu63_mixed_spherical_norot.root 2> err

cd output/demo_2 
root -b -l -q -x "../../macro/demo_2/profile2_deformation_U.C(\"output_minbias_UU_mixed_deformed_norot.root\",\"output_minbias_UU_mixed_spherical_norot.root\")"
$VIEW rcostheta_spherical_deformed_U.pdf 2> err &
root -b -l -q -x "../../macro/demo_2/profile2_deformation_63Cu.C(\"output_minbias_Cu63Cu63_mixed_deformed_norot.root\",\"output_minbias_Cu63Cu63_mixed_spherical_norot.root\")"
$VIEW rcostheta_spherical_deformed_63Cu.pdf 2> err &
cd ../..

else
echo "Part of the script to run deformed and spherical U+U, Au+Au and Cu+Cu collisions is NOT EXECUTED"
fi
echo ""

echo "A sample run with nuclear correlations read from external files"
echo "(First, you must get and save files from http://sites.psu.edu/color/ and create one big file," 
echo "for instance running cat ca16-01.dat ca16-02.dat [more files] > ca16.dat, which must be placed in subdirectory 'nucl')"
echo "$QUESTION"

read ANSWER

if [[ "$ANSWER" == "yes" || "$ANSWER" == "YES" || "$ANSWER" == "y" || "$ANSWER" == "Y" ]]; then
  if [ -f "nucl/ca40.dat" ] ; then
  make clean
  make 'PREPROCESS =  -D_nnwp_=2 -D_bindep_=1 -D_files_=1 -D_profile_=1 -D_weight_=1 -D_evout_=0 -D_clusters_=0 -D_uncluster_=0 -D_partons_=0 -D_pardis_=0 -D_rdsconv_=1'
  ./glissando3 input/demo_2/input_CA40.dat output/demo_2/CA40.root nucl/ca40.dat nucl/ca40.dat 2> err
  cd output/demo_2
  root -b -l -q -x "../../macro/demo_2/corr.C(\"CA40.root\")"
  $VIEW corr.pdf 2> err &
  root -b -l -q -x "../../macro/demo_2/wounding_profile.C(\"CA40.root\")"
  $VIEW wounding_pr.pdf 2> err &
  cd ../..

  else
  echo "file nucl/ca40.dat does not exist!"
  fi

else
echo "Part of the script for the sample run with nuclear correlations read from external files is NOT EXECUTED"
fi
echo ""


echo "Write the event-by-event info to file out.root.points (LARGE OUTPUT DATA!)"
echo "$QUESTION"

read ANSWER

if [[ "$ANSWER" == "yes" || "$ANSWER" == "YES" || "$ANSWER" == "y" || "$ANSWER" == "Y" ]]; then
# compile with standard precompiler options
make clean
make 'PREPROCESS =  -D_nnwp_=2 -D_bindep_=1 -D_files_=0 -D_profile_=0 -D_weight_=0 -D_evout_=1 -D_clusters_=0 -D_uncluster_=0 -D_partons_=0 -D_pardis_=0 -D_rdsconv_=1'

./glissando3 input/demo_2/input.dat output/demo_2/out.root

else
echo "Part of the script to write the event-by-event info to file out.root.points (LARGE OUTPUT DATA!) is NOT EXECUTED"
fi
echo ""

echo "Demo of down-compatibility with GLISSANDO 2 completed!"
